/**
 * IAU 2000 R06 nutation terms in obliquity, derived from the IAU 2000A lunisolar and planetary
 * components with slight IAU 2006 adjustments.
 *
 * Extracted from https://iers-conventions.obspm.fr/content/chapter5/additional_info/tab5.3b.txt
 *
 * This file a C source code snippet, which should be included in 'nutation.c' after the
 * definition of the 'nutation_terms' data structure.
 *
 * @version IERS Conventions v1.3.0
 */

static const nutation_terms B0[1037] = { //
        {      153770,   920523310, {   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  4,  5 }, //
        {      -45870,    57303360, {   0,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       13740,     9784610, {   0,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {       -2910,    -8974920, {   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  4,  5 }, //
        {       -1740,     2243860, {   0,   1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        3180,     2007300, {   0,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        3670,     1290260, {   1,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -1320,     -959290, {   0,   1,  -2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {      -19240,      738710, {   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  2 }, //
        {         390,     -689820, {   0,   0,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {          40,     -533110, {   1,   0,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -90,     -332280, {   1,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         750,      314290, {   1,   0,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         780,      263660, {   1,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -660,      255450, {   1,   0,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -200,     -242360, {   2,   0,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         680,      164500, {   0,   0,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,     -138700, {   0,   2,  -2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         590,      132380, {   2,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,     -123380, {   1,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,     -107580, {   1,   0,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -450,       85510, {   0,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          10,      -80010, {   1,   0,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        3580,      -67500, {   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  1 }, //
        {        -140,       69530, {   1,   0,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -50,       68500, {   0,   2,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -260,       64150, {   0,   1,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -150,       52220, {   1,   0,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       27350,       16470, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,  -2,   5,   0,   0,   0 },  2, 11 }, //
        {         140,       33530, {   0,   0,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         190,       32660, {   1,   0,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,       32720, {   0,   0,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {         -50,      -32500, {   0,   1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -40,       30700, {   0,   1,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          50,       30410, {   2,   0,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -10,      -30450, {   1,   0,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -40,      -27680, {   2,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          90,       27200, {   0,   0,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {          30,       27190, {   0,   1,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         120,       26950, {   2,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          10,      -22060, {   2,   0,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       12860,       -7710, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  -5,   0,   0,  -1 },  9, 14 }, //
        {          10,      -19000, {   0,   1,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {       16790,           0, {   0,   1,  -1,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -820,      -12350, {   1,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          10,       13110, {   2,   0,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,       12660, {   2,   0,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         290,      -12200, {   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  4 }, //
        {          70,       12320, {   3,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,       12320, {   1,  -1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,       12070, {   1,   1,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -50,       11290, {   0,   1,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -20,      -11290, {   2,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          20,       10730, {   1,   0,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -30,      -10620, {   1,   1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        3190,       -6410, {   0,   0,   1,  -1,   1,   0,  -8,  12,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,        8950, {   0,   0,   0,   0,   0,   0,   3,  -5,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        8910,           0, {   1,   0,  -1,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        8540, {   1,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -20,       -7100, {   0,   0,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,       -7000, {   1,  -1,   0,  -1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        1390,       -5530, {   1,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,        6720, {   0,   2,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          40,        6630, {   1,   0,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -40,        6470, {   1,   0,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         130,       -6090, {   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  1 }, //
        {         -20,       -6100, {   1,   0,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          20,       -5920, {   2,   0,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         110,       -5500, {   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  3 }, //
        {           0,       -5560, {   1,   1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -10,       -5270, {   2,   0,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -20,        5180, {   2,   0,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         100,       -4950, {   1,   0,   0,  -1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        5050, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   2 },  9, 14 }, //
        {         250,        4770, {   2,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          10,        4960, {   1,   0,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          10,       -4900, {   1,   0,  -4,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -2320,        2460, {   0,   0,   0,   0,   1,   0,   0,  -1,   2,   0,   0,   0,   0,   0 },  4,  9 }, //
        {          40,        4650, {   2,   0,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -10,       -4400, {   0,   0,   2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         -10,       -4220, {   0,   1,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        1330,        2690, {   0,   0,   0,   0,   0,   0,   8, -13,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -10,       -3990, {   3,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -10,       -3950, {   0,   0,   4,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,       -3910, {   1,   1,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -10,       -3890, {   2,   0,  -2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          10,        3690, {   0,   0,   2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         -10,        3460, {   0,   1,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          20,       -3260, {   0,   1,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -10,        3160, {   1,   1,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        3040, {   0,   0,   2,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {          20,        2940, {   0,   0,   2,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,       -2790, {   1,  -1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          10,        2750, {   1,   0,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -2570,        -170, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   2,  -5,   0,   0,   0 },  2, 11 }, //
        {           0,        2580, {   1,  -1,   0,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        1990,         590, {   0,   0,   0,   0,   0,   0,   0,   2,  -8,   3,   0,   0,   0,  -2 },  7, 14 }, //
        {          20,        2520, {   1,  -1,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,       -2530, {   0,   1,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          20,        2500, {   3,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -10,        2440, {   1,   0,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          10,       -2440, {   1,  -1,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -2330,          90, {   0,   0,   2,  -2,   1,   0,  -5,   6,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -10,        2400, {   1,   1,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -1800,        -530, {   0,   0,   0,   0,   0,   0,   0,   6,  -8,   3,   0,   0,   0,   2 },  7, 14 }, //
        {         -10,       -2280, {   0,   1,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -10,        2250, {   0,   1,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          10,        2160, {   1,  -1,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,       -2130, {   0,   0,   0,   0,   0,   0,   4,  -6,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {          10,        2070, {   2,  -1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          70,       -2010, {   0,   0,   0,   0,   0,   0,   0,   3,   0,  -1,   0,   0,   0,   2 },  7, 14 }, //
        {           0,        2050, {   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {        1590,        -450, {   0,   0,   0,   0,   1,   0,   0,  -4,   8,  -3,   0,   0,   0,   0 },  4, 10 }, //
        {           0,        2010, {   0,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {          20,       -1990, {   1,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,       -2000, {   1,  -1,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        1560,         440, {   0,   0,   0,   0,   1,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  4, 10 }, //
        {           0,        1980, {   0,   0,   0,   0,   0,   0,   2,  -4,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,        1890, {   1,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         430,       -1460, {   0,   0,   1,  -1,   1,   0,   0,   0,  -2,   0,   0,   0,   0,   0 },  2,  9 }, //
        {         -10,       -1850, {   1,   1,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -10,        1840, {   0,   1,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,        1810, {   0,   3,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {        -130,       -1670, {   0,   0,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  4 }, //
        {         100,        1680, {   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  2 }, //
        {         -10,       -1760, {   2,   1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -1760,           0, {   1,   0,  -1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,       -1740, {   0,   0,   0,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {        1450,        -270, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   1 },  9, 14 }, //
        {           0,        1710, {   1,   0,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          10,       -1700, {   0,   0,   2,  -2,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,        1620, {   1,  -1,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,       -1600, {   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {           0,       -1540, {   1,   0,  -2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,       -1510, {   2,   0,   0,  -2,  -1,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {           0,        1470, {   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {         -10,       -1430, {   1,   0,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        1440, {   1,   0,   2,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,       -1440, {   0,   0,   2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,       -1380, {   1,   0,  -2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {       -1380,           0, {   0,   0,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         450,        -930, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,  -1,   0,   0,   0 },  2, 11 }, //
        {           0,       -1340, {   1,   0,   0,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -10,        1310, {   1,   0,  -2,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        1030,         270, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,  -1,   0,   0,   0,   0 },  2, 10 }, //
        {           0,       -1280, {   1,   1,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        1280, {   1,   0,  -2,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        1170,          80, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  -5,   0,   0,   1 },  9, 14 }, //
        {           0,       -1200, {   2,   0,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        1130,          50, {   0,   0,   0,   0,   0,   0,   5,  -8,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,        1140, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   1,   0,   0,   0,   2 },  7, 14 }, //
        {           0,       -1120, {   1,   1,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          10,        1090, {   4,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,       -1080, {   2,   1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          10,       -1070, {   1,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {         -20,        1040, {   2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {           0,        1050, {   2,   0,  -2,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,       -1040, {   1,   0,   4,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        1040, {   0,   1,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,       -1020, {   0,   1,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,       -1000, {   1,   0,  -4,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         960, {   1,   0,   0,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          10,         940, {   2,   0,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -760,         170, {   0,   0,   0,   0,   0,   0,   8, -13,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -770,         140, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   2,   0,   0,   0,   0 },  2, 10 }, //
        {         140,        -750, {   0,   0,   1,  -1,   1,   0,  -5,   7,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         610,        -270, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   1 }, 10, 14 }, //
        {           0,        -870, {   0,   0,   0,   0,   0,   0,   5,  -7,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -590,         260, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,   2,   0,   0,   0 },  2, 11 }, //
        {           0,         840, {   0,   0,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        -260,        -570, {   1,   0,   2,   0,   2,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         830, {   0,   0,   2,  -3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         -20,        -810, {   0,   1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {         270,         550, {   1,   0,  -2,   0,  -2,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  0, 10 }, //
        {         420,        -400, {   0,   0,   0,   0,   0,   0,   0,   8, -16,   4,   5,   0,   0,  -2 },  7, 14 }, //
        {           0,         810, {   0,   1,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -10,         800, {   0,   0,   0,   0,   0,   0,   0,   4,   0,  -2,   0,   0,   0,   2 },  7, 14 }, //
        {        -130,         670, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -1,   0,   0,   0,   2 },  7, 14 }, //
        {           0,        -790, {   0,   0,   4,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,         780, {   0,   0,   0,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {        -750,         -20, {   0,   0,   0,   0,   0,   0,   2,  -1,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {         -50,        -720, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   1,   0,   0,   0,   2 },  7, 14 }, //
        {         490,         270, {   0,   0,   0,   0,   0,   0,   8, -11,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,        -750, {   3,   0,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -750, {   2,   0,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         750, {   1,   1,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -720, {   0,   0,   4,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {          10,         690, {   1,   0,   2,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -560,         140, {   0,   0,   0,   0,   0,   0,   4,  -6,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {        -570,        -130, {   0,   0,   0,   0,   0,   0,   1,  -1,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,         690, {   2,   1,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         690, {   1,   1,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         420,        -270, {   0,   0,   0,   0,   0,   0,   8, -15,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -310,         370, {   0,   0,   0,   0,   0,   0,   0,   1,   2,   0,   0,   0,   0,   2 },  7, 14 }, //
        {        -390,        -290, {   0,   0,   0,   0,   0,   0,   0,   3,   0,  -2,   0,   0,   0,   2 },  7, 14 }, //
        {           0,         660, {   3,   0,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -310,        -350, {   0,   0,   0,   0,   0,   0,   0,   3,  -2,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         110,        -540, {   1,   0,   0,  -1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -640, {   2,   0,   0,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          90,         550, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   2 },  9, 14 }, //
        {           0,        -630, {   0,   0,   2,  -2,   1,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -10,        -620, {   0,   0,   0,   0,   0,   0,   0,   4,  -2,   0,   0,   0,   0,   2 },  7, 14 }, //
        {           0,        -610, {   1,   1,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         610, {   0,   0,   2,  -1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,         610, {   0,   0,   1,  -1,   1,   0,   0,   3,  -8,   3,   0,   0,   0,   0 },  2, 10 }, //
        {           0,         600, {   0,   0,   2,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         350,        -250, {   0,   0,   0,   0,   1,   0,   8, -13,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {           0,         590, {   1,  -1,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         570, {   2,   0,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -90,        -480, {   2,   0,   0,  -2,   1,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {           0,         570, {   1,  -1,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         570, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   2 }, 10, 14 }, //
        {          10,         560, {   3,   0,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          20,        -540, {   2,   1,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         560, {   2,   0,   0,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         560, {   1,   0,   0,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -90,        -470, {   0,   0,   0,   0,   0,   0,   5,  -8,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -40,        -510, {   1,   1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         550, {   0,   2,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,        -540, {   2,   0,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         180,         360, {   1,   0,   0,   0,  -1,   0, -18,  16,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,        -540, {   0,   0,   0,   0,   0,   0,   0,   8, -16,   4,   5,   0,   0,   2 },  7, 14 }, //
        {           0,         530, {   1,  -1,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -530, {   0,   0,   1,  -1,   1,   0,   0,  -5,   8,  -3,   0,   0,   0,   0 },  2, 10 }, //
        {           0,        -520, {   0,   0,   0,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {           0,        -520, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -3,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,         510, {   0,   2,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         300,         210, {   0,   0,   0,   0,   1,   0,  -8,  13,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {           0,        -510, {   0,   0,   0,   0,   0,   0,   6,  -8,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,        -500, {   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  1 }, //
        {           0,         500, {   1,  -1,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -500, {   1,  -1,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          90,        -410, {   0,   0,   0,   0,   1,   0,   0,   0,   0,  -2,   5,   0,   0,   0 },  4, 11 }, //
        {        -500,           0, {   0,   0,   0,   0,   0,   0,   3,  -2,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {           0,        -490, {   4,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         490,           0, {   0,   0,   0,   0,   0,   0,   2,  -5,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,        -490, {   0,   0,   0,   0,   0,   0,   1,  -3,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -370,        -110, {   0,   0,   0,   0,   1,   0,   0,   0,   0,   1,   0,   0,   0,   0 },  4, 10 }, //
        {           0,         480, {   2,   1,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          90,         390, {   0,   0,   0,   0,   1,   0,   0,   0,   0,   2,  -5,   0,   0,   0 },  4, 11 }, //
        {           0,         470, {   1,   0,   2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -470, {   0,   2,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,        -450, {   2,   1,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -450, {   2,  -1,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -150,        -300, {   1,   0,   0,   0,   1,   0, -18,  16,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         440, {   2,   0,   0,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         440, {   1,   2,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -440, {   1,  -1,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,        -410, {   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  2 }, //
        {           0,        -430, {   3,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         430, {   2,   0,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -430, {   0,   1,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         430, {   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  4,  5 }, //
        {          20,         400, {   1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {          20,         400, {   0,   2,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         410, {   3,   0,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -60,         350, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,   1,   0,   0,   0 },  2, 11 }, //
        {           0,         400, {   1,   0,  -4,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -400, {   0,   1,  -2,   1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         310,         -80, {   0,   0,   0,   0,   0,   0,   2,  -4,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,         390, {   2,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         390, {   2,  -1,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         390, {   2,  -1,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -390, {   1,   0,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,        -390, {   1,   0,  -2,  -3,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         390, {   0,   1,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         190,         200, {   0,   0,   0,   0,   1,   0,   0,   1,  -2,   0,   0,   0,   0,   0 },  4,  9 }, //
        {           0,         380, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -20,         350, {   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  2 }, //
        {           0,        -360, {   1,   1,  -2,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -360, {   1,   0,  -2,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -210,         150, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   2,   0,   0,   0,   2 },  7, 14 }, //
        {          70,         280, {   0,   0,   0,   0,   0,   0,   3,  -7,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -290,         -60, {   0,   0,   0,   0,   0,   0,   2,  -2,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,        -350, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0 },  7,  8 }, //
        {        -280,          70, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,  -1 },  9, 14 }, //
        {           0,         340, {   2,   0,  -4,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -340, {   1,  -1,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -330, {   2,   1,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          50,         280, {   2,   0,   0,  -2,  -1,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {           0,         330, {   1,   1,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         260,         -70, {   0,   0,   0,   0,   0,   0,   3,  -5,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         100,        -230, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   2 },  9, 14 }, //
        {           0,         320, {   1,  -1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -320, {   0,   2,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         320, {   0,   2,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,        -320, {   0,   0,   0,   0,   0,   0,   7,  -9,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,         320, {   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   2 },  8, 14 }, //
        {         290,         -30, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   1 },  9, 14 }, //
        {           0,        -310, {   1,   0,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -70,        -240, {   0,   0,   0,   0,   0,   0,   3,  -3,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {           0,         300, {   2,   0,   2,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -160,         140, {   1,   0,   0,  -1,   1,   0,   0,  -1,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {        -290,         -10, {   0,   0,   0,   0,   0,   0,   4,  -7,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,        -290, {   2,   0,   0,  -2,   1,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {           0,        -290, {   1,   0,   2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         290, {   0,   1,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {        -250,          40, {   0,   0,   1,  -1,   1,   0,   0,  -2,   2,   0,   0,   0,   0,   0 },  2,  9 }, //
        {          40,        -250, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1 }, 10, 14 }, //
        {           0,        -280, {   2,   1,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -250,          30, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  2, 10 }, //
        {        -250,         -30, {   0,   0,   0,   0,   0,   0,   0,   1,  -2,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {         270,           0, {   1,   0,  -1,   0,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -270, {   0,   0,   2,  -2,   1,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  2, 10 }, //
        {           0,         260, {   3,  -1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -260, {   0,   1,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,        -260, {   0,   1,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         210,          50, {   0,   0,   1,  -1,   1,   0,  -3,   4,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,        -250, {   2,   0,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         250, {   0,   1,   0,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         190,         -60, {   0,   0,   0,   0,   0,   0,   0,   6, -16,   4,   5,   0,   0,  -2 },  7, 14 }, //
        {          80,         170, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,  -1 }, 10, 14 }, //
        {           0,        -240, {   2,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         240, {   2,   0,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -10,        -230, {   2,   0,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,        -240, {   1,   1,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         240, {   1,   0,   2,  -3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -190,          50, {   0,   0,   0,   0,   0,   0,   5,  -7,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -10,        -220, {   0,   0,   0,   0,   0,   0,   8, -10,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,        -230, {   3,   1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         230, {   1,   1,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -140,          90, {   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   2 },  8, 14 }, //
        {           0,         220, {   4,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -220, {   2,  -1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         220, {   1,   1,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         220, {   1,  -2,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         220, {   0,   1,   2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -20,        -200, {   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  4 }, //
        {        -180,         -40, {   0,   0,   0,   0,   0,   0,   3,  -3,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,         220, {   0,   0,   0,   0,   0,   0,   0,   2,  -4,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,        -210, {   2,   1,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -210, {   1,   0,   4,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         210, {   1,   0,   2,  -1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         210, {   1,   0,  -2,   1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         210, {   1,  -1,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -170,          40, {   0,   0,   0,   0,   0,   0,   1,  -1,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {         -80,        -130, {   0,   0,   0,   0,   0,   0,   0,   5,  -4,   0,   0,   0,   0,   2 },  7, 14 }, //
        {        -130,         -80, {   0,   0,   0,   0,   0,   0,   0,   4,  -4,   0,   0,   0,   0,   2 },  7, 14 }, //
        {           0,         200, {   2,  -2,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -200, {   1,   2,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -200, {   1,   0,   2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         200, {   1,   0,  -2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         200, {   1,  -1,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         200,           0, {   0,   0,   0,   0,   0,   0,   6,  -9,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         160,         -40, {   0,   0,   0,   0,   0,   0,   1,  -3,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         110,         -90, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,  -5,   0,   0,  -2 },  9, 14 }, //
        {         -30,         160, {   0,   0,   0,   0,   0,   0,   0,   4,   0,  -3,   0,   0,   0,   2 },  7, 14 }, //
        {           0,        -190, {   3,   0,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -190, {   2,   0,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         190, {   2,  -1,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -190, {   1,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         190, {   1,  -1,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         190, {   0,   0,   4,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {        -100,          90, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,   0,   0,   2,   0 },  2, 13 }, //
        {        -140,         -50, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,  -4,  10,   0,   0,   0 },  2, 11 }, //
        {         150,          40, {   0,   0,   1,  -1,   1,   0,  -4,   5,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,        -190, {   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  4 }, //
        {           0,         190, {   0,   0,   0,   4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {        -150,         -40, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   1 },  7, 14 }, //
        {           0,         180, {   2,   0,  -2,  -6,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -180, {   2,   0,  -4,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -180, {   2,  -1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          20,        -160, {   0,   0,   0,   0,   0,   0,   2,  -3,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {        -110,          70, {   0,   0,   0,   0,   0,   0,   0,   2,  -4,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {         -60,        -110, {   1,   0,   2,   0,   1,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {          60,         110, {   1,   0,  -2,   0,  -1,   0,   0,  -1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {        -110,          60, {   0,   0,   0,   0,   1,   0,   0,  -2,   4,   0,   0,   0,   0,   0 },  4,  9 }, //
        {         -60,        -110, {   0,   0,   0,   0,   0,   0,   0,   4,  -3,   0,   0,   0,   0,   2 },  7, 14 }, //
        {           0,        -170, {   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  4 }, //
        {        -120,         -50, {   0,   0,   2,  -2,   1,   0,   0,  -9,  13,   0,   0,   0,   0,   0 },  2,  9 }, //
        {         150,          20, {   0,   0,   1,   1,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {        -170,           0, {   0,   0,   0,   0,   1,   0,   2,  -3,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {           0,        -160, {   2,   0,   4,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -50,        -110, {   2,   0,   2,   0,   2,   0,   0,   2,   0,  -3,   0,   0,   0,   0 },  0, 10 }, //
        {           0,        -160, {   1,   1,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         160, {   1,   0,   0,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         160, {   0,   1,  -2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,        -160, {   0,   0,   4,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,        -160, {   0,   0,   2,   3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         110,         -50, {   0,   0,   1,  -1,   2,   0,   0,  -1,   0,   0,   2,   0,   0,   0 },  2, 11 }, //
        {        -130,         -30, {   0,   0,   0,   0,   0,   0,   4,  -4,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {          60,         100, {   0,   0,   0,   0,   0,   0,   0,   3,  -6,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          30,        -130, {   0,   0,   0,   0,   0,   0,   0,   1,  -2,   0,   0,   0,   0,   1 },  7, 14 }, //
        {         120,         -40, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   1 },  9, 14 }, //
        {           0,         150, {   2,   0,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         150, {   2,  -1,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -150, {   1,   2,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         150, {   1,   1,  -2,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -150, {   1,   0,   0,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         150,           0, {   1,   0,   0,  -1,   1,   0,  -3,   4,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         150, {   1,   0,   0,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -150, {   1,  -1,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,        -150, {   0,   1,   4,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,        -150, {   0,   1,   2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -50,         100, {   0,   0,   2,   0,   2,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         150, {   0,   0,   0,   0,   1,   0,   1,  -1,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {         130,         -20, {   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   1,   0,   0,   0 },  4, 11 }, //
        {           0,        -150, {   0,   0,   0,   0,   0,   0,   9, -11,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -120,         -30, {   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {        -140,          10, {   0,   0,   0,   0,   0,   0,   0,   4,   0,  -1,   0,   0,   0,   2 },  7, 14 }, //
        {          20,        -130, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -4,   0,   0,   0,  -2 },  7, 14 }, //
        {         -50,         100, {   0,   0,   0,   0,   0,   0,   0,   1,  -8,   3,   0,   0,   0,  -2 },  7, 14 }, //
        {         110,         -30, {   0,   0,   1,  -1,   1,   0,  -1,   0,   0,   0,   0,   0,   0,   0 },  2,  7 }, //
        {         -30,         110, {   0,   0,   0,   0,   1,   0,  -3,   5,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {           0,        -140, {   3,   0,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -140, {   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {          20,         120, {   2,  -1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         140, {   1,   0,   2,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         140, {   1,   0,  -2,  -6,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -140, {   1,  -2,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         140, {   0,   1,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {           0,        -140, {   0,   0,   2,  -2,   1,   0,  -4,   4,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,        -140, {   0,   0,   2,  -3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         140,           0, {   0,   0,   1,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,        -130, {   3,   1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -130,           0, {   1,   0,   0,  -1,  -1,   0,  -3,   4,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,        -130, {   1,   0,  -4,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -130, {   1,  -1,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         130, {   1,  -2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -130, {   0,   0,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         -80,          50, {   0,   0,   1,  -1,   1,   0,   3,  -6,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -20,        -110, {   0,   0,   0,   0,   0,   0,   6, -10,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,        -130, {   0,   0,   0,   0,   0,   0,   3,  -1,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {           0,        -130, {   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,  -1,   0,   0,   2 },  7, 14 }, //
        {         110,          20, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -2,   0,   0,   0,   1 },  7, 14 }, //
        {         -70,         -60, {   0,   0,   1,  -1,   1,   0,   8, -14,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -40,         -80, {   0,   0,   0,   0,   1,   0,   0,   8, -15,   0,   0,   0,   0,   0 },  4,  9 }, //
        {          40,          80, {   0,   0,   0,   0,   0,   0,   0,   1,  -4,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         -40,          80, {   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   2 },  8, 14 }, //
        {           0,        -120, {   2,   1,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         120, {   2,   0,   2,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         120, {   1,   2,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -120, {   1,   1,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -70,         -50, {   0,   0,   1,  -1,   1,   0,   0,  -3,   4,   0,   0,   0,   0,   0 },  2,  9 }, //
        {        -100,          20, {   0,   0,   0,   0,   0,   0,   6,  -8,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         120,           0, {   0,   0,   0,   0,   0,   0,   3,  -6,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {        -100,          20, {   0,   0,   0,   0,   0,   0,   2,   1,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {          20,        -100, {   0,   0,   0,   0,   0,   0,   2,   1,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {           0,         110, {   3,   0,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         110, {   3,   0,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -110, {   2,   1,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         110, {   2,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -20,          90, {   2,   0,   0,  -2,   1,   0,  -6,   8,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         110, {   2,  -1,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -110,           0, {   1,   0,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -110, {   1,  -1,  -2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -50,          60, {   1,  -2,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -110,           0, {   0,   0,   3,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         -90,         -20, {   0,   0,   0,   0,   0,   0,   5,  -5,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,         110, {   0,   0,   0,   0,   0,   0,   0,   7,  -8,   3,   0,   0,   0,   2 },  7, 14 }, //
        {         -40,         -70, {   0,   0,   0,   0,   0,   0,   0,   4,  -7,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          60,         -50, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   1 }, 12, 14 }, //
        {           0,        -100, {   3,   0,   0,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         100, {   2,   0,  -2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -100, {   1,   0,   4,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {        -100,           0, {   1,   0,   1,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -100, {   1,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         100, {   1,   0,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         100, {   1,   0,  -4,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         100, {   1,  -1,   2,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         100, {   0,   2,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         100, {   0,   2,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,        -100, {   0,   1,   2,  -2,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         100, {   0,   1,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         100,           0, {   0,   0,   1,  -1,   1,   0,   0,  -9,  15,   0,   0,   0,   0,   0 },  2,  9 }, //
        {          80,         -20, {   0,   0,   0,   0,   1,   0,   0,   0,   0,  -1,   0,   0,   0,   0 },  4, 10 }, //
        {           0,         100, {   0,   0,   0,   0,   1,   0,  -1,   1,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {         100,           0, {   0,   0,   0,   0,   1,   0,  -2,   3,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {         100,           0, {   0,   0,   0,   0,   0,   0,   7, -10,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {          40,          60, {   0,   0,   0,   0,   0,   0,   3,  -5,   4,   0,   0,   0,   0,   2 },  6, 14 }, //
        {         -40,         -60, {   0,   0,   0,   0,   0,   0,   3,  -9,   4,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         -80,         -20, {   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {           0,          90, {   5,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -90, {   4,   0,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          90, {   3,   0,  -2,  -6,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          90, {   2,   1,  -2,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -90, {   2,   0,   0,  -2,   1,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         -90, {   1,   2,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          90, {   1,   0,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,          90, {   1,   0,  -2,   4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          90, {   1,   0,  -2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -90, {   1,  -1,   2,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -90, {   1,  -1,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {          10,          80, {   1,  -1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,          90, {   0,   1,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -90, {   0,   0,   1,  -1,   1,   0,  -2,   2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -50,         -40, {   0,   0,   0,   0,   0,   0,   0,   3,   0,  -3,   0,   0,   0,   2 },  7, 14 }, //
        {         -90,           0, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,  -1,   0,   0,   2 },  7, 14 }, //
        {         -70,         -20, {   0,   0,   0,   0,   0,   0,   6,  -6,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {          70,         -20, {   0,   0,   0,   0,   0,   0,   1,   2,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {         -30,          60, {   0,   0,   0,   0,   0,   0,   0,   8, -15,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,          80, {   3,   0,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -80, {   3,   0,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -80, {   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  2 }, //
        {           0,         -80, {   2,  -1,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          80, {   1,   2,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          80, {   1,   1,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -80, {   1,   0,  -2,  -3,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          80, {   0,   1,   0,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -80, {   0,   1,  -2,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -80, {   0,   0,   4,  -4,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,          80, {   0,   0,   4,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {         -30,         -50, {   0,   0,   0,   0,   1,   0,   3,  -7,   4,   0,   0,   0,   0,   0 },  4,  9 }, //
        {           0,         -80, {   0,   0,   0,   0,   1,   0,   0,   1,   0,  -1,   0,   0,   0,   0 },  4, 10 }, //
        {         -30,          50, {   0,   0,   0,   0,   1,   0,  -3,   7,  -4,   0,   0,   0,   0,   0 },  4,  9 }, //
        {         -60,          20, {   0,   0,   0,   0,   0,   0,   7,  -9,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {          20,          60, {   0,   0,   0,   0,   0,   0,   4,  -7,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -50,          30, {   0,   0,   0,   0,   0,   0,   3,  -5,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {         -50,         -30, {   0,   0,   0,   0,   0,   0,   0,   5,  -5,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -50,         -30, {   0,   0,   0,   0,   0,   0,   0,   5,  -9,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,         -80, {   0,   0,   0,   0,   0,   0,   0,   3,  -1,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -30,          50, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   2,  -5,   0,   0,   2 },  7, 14 }, //
        {         -80,           0, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   1,   0,   0,   2 },  7, 14 }, //
        {         -30,         -50, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -2,   5,   0,   0,   2 },  7, 14 }, //
        {          10,          70, {   0,   0,   0,   0,   0,   0,   7, -11,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         -70,          10, {   0,   0,   0,   0,   0,   0,   2,  -2,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {           0,          70, {   4,   0,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          70, {   3,   0,   0,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          10,         -60, {   2,   0,   0,  -2,  -1,   0,  -6,   8,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         -70, {   2,   0,  -2,  -3,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          70, {   2,  -1,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          70, {   1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,          70, {   1,  -1,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -70, {   0,   1,   2,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,          70, {   0,   1,  -2,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,          70, {   0,   1,  -4,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          70,           0, {   0,   0,   1,  -1,   2,   0,   0,  -2,   2,   0,   0,   0,   0,   0 },  2,  9 }, //
        {         -70,           0, {   0,   0,   1,  -1,   1,   0,   2,  -4,   0,  -3,   0,   0,   0,   0 },  2, 10 }, //
        {         -50,          20, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   3,   0,   0,   0,   0 },  2, 10 }, //
        {          70,           0, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,  -1,   1,   0,   0,   0 },  2, 11 }, //
        {           0,         -70, {   0,   0,   0,   0,   1,   0,   3,  -5,   0,   2,   0,   0,   0,   0 },  4, 10 }, //
        {         -20,         -50, {   0,   0,   0,   0,   0,   0,   9,  -9,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -60,         -10, {   0,   0,   0,   0,   0,   0,   3,  -1,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {          60,         -10, {   0,   0,   0,   0,   0,   0,   3,  -3,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {          50,         -20, {   0,   0,   0,   0,   0,   0,   2,  -3,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {          20,          50, {   0,   0,   0,   0,   0,   0,   0,  11,   0,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -20,         -50, {   0,   0,   0,   0,   0,   0,   0,   6, -15,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          40,          30, {   0,   0,   0,   0,   0,   0,   0,   4,  -8,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          50,         -20, {   0,   0,   0,   0,   0,   0,   0,   3,   0,   2,  -5,   0,   0,   2 },  7, 14 }, //
        {         -50,          20, {   0,   0,   0,   0,   0,   0,   0,   3,   0,   1,   0,   0,   0,   2 },  7, 14 }, //
        {           0,         -70, {   0,   0,   0,   0,   0,   0,   0,   3,  -5,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,         -70, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -4,   0,   0,   0,  -2 },  7, 14 }, //
        {          70,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   2 }, 10, 14 }, //
        {         -40,          20, {   2,   0,  -1,  -1,  -1,   0,   0,  -1,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {          20,          40, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,   3,   0,   0,   0 },  2, 11 }, //
        {          40,          20, {   0,   0,   0,   0,   1,   0,   0,   2,  -4,   0,   0,   0,   0,   0 },  4,  9 }, //
        {         -40,          20, {   0,   0,   0,   0,   0,   1,   0,  -4,   0,   0,   0,   0,   0,  -2 },  5, 14 }, //
        {          40,         -20, {   0,   0,   0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -40,         -20, {   0,   0,   0,   0,   0,   0,   0,   6,  -6,   0,   0,   0,   0,   2 },  7, 14 }, //
        {          40,          20, {   0,   0,   0,   0,   0,   0,   0,   1,  -5,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         -20,         -40, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   1 }, 10, 14 }, //
        {           0,          60, {   4,   0,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          60, {   3,   0,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          60, {   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  2 }, //
        {           0,         -60, {   2,   1,   0,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -60, {   2,   0,   0,  -2,  -1,   0,   0,  -2,   0,   0,   5,   0,   0,   0 },  0, 11 }, //
        {           0,         -60, {   2,   0,  -2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -60, {   1,   1,   0,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          60, {   1,   1,   0,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          60, {   1,   1,   0,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          60, {   1,   0,   0,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -60, {   1,   0,  -2,  -2,  -2,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {           0,         -60, {   1,  -1,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -60, {   0,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {           0,          60, {   0,   0,   2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {          60,           0, {   0,   0,   2,  -2,   2,   0,  -8,  11,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         -60, {   0,   0,   2,  -2,   1,   0,  -2,   2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          50,          10, {   0,   0,   1,  -1,   1,   0,  -2,   3,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          10,         -50, {   0,   0,   1,  -1,  -1,   0,   0,   0,  -2,   0,   0,   0,   0,   0 },  2,  9 }, //
        {           0,         -60, {   0,   0,   0,   3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {           0,         -60, {   0,   0,   0,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {           0,         -60, {   0,   0,   0,   0,   1,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  4, 10 }, //
        {          30,          30, {   0,   0,   0,   0,   0,   0,   8, -13,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {         -50,         -10, {   0,   0,   0,   0,   0,   0,   7,  -7,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -10,         -50, {   0,   0,   0,   0,   0,   0,   4,  -4,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {          10,          50, {   0,   0,   0,   0,   0,   0,   1,  -2,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {          50,         -10, {   0,   0,   0,   0,   0,   0,   0,   5,   0,  -2,   0,   0,   0,   2 },  7, 14 }, //
        {         -10,          50, {   0,   0,   0,   0,   0,   0,   0,   3,  -6,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {           0,          60, {   0,   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   2 },  7, 14 }, //
        {           0,          60, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   0,   0,   2 },  7, 14 }, //
        {           0,          50, {   3,  -1,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -50, {   3,  -1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          50, {   3,  -1,  -2,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          10,          40, {   2,   1,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,          50, {   2,   1,   0,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -50, {   2,   1,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          50, {   2,   0,   2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,         -20, {   2,   0,   0,  -2,   1,   0,   0,  -6,   8,   0,   0,   0,   0,   0 },  0,  9 }, //
        {         -20,          30, {   2,   0,   0,  -2,  -1,   0,   0,  -5,   6,   0,   0,   0,   0,   0 },  0,  9 }, //
        {          20,          30, {   2,   0,  -1,  -1,  -1,   0,   0,   3,  -7,   0,   0,   0,   0,   0 },  0,  9 }, //
        {           0,          50, {   2,   0,  -4,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -50, {   1,   1,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -50, {   1,   1,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -50, {   1,   0,   0,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          50, {   1,   0,   0,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          50, {   1,   0,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,          50, {   1,  -2,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -50, {   1,  -2,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -50, {   0,   1,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,          50, {   0,   1,  -2,   2,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -50, {   0,   1,  -2,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -50,           0, {   0,   0,   3,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,          50, {   0,   0,   2,   6,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {          40,          10, {   0,   0,   2,   0,   2,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  2, 10 }, //
        {          40,         -10, {   0,   0,   2,   0,   2,   0,   0,  -4,   8,  -3,   0,   0,   0,   0 },  2, 10 }, //
        {           0,          50, {   0,   0,   2,  -2,   2,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          50,           0, {   0,   0,   2,  -2,   2,   0,  -5,   6,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          40,          10, {   0,   0,   2,  -2,   1,  -1,   0,   2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -50,           0, {   0,   0,   1,  -1,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -40,         -10, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,   0,   2,   0,   0 },  2, 12 }, //
        {          10,          40, {   0,   0,   0,   0,   1,   0,   3,  -5,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {          50,           0, {   0,   0,   0,   0,   0,   0,   9, -12,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,         -50, {   0,   0,   0,   0,   0,   0,   6,  -9,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {          40,         -10, {   0,   0,   0,   0,   0,   0,   5,  -6,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {         -40,          10, {   0,   0,   0,   0,   0,   0,   5, -10,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         -50,           0, {   0,   0,   0,   0,   0,   0,   4,  -4,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {          30,          20, {   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {         -30,          20, {   0,   0,   0,   0,   0,   0,   0,   7, -13,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         -50,           0, {   0,   0,   0,   0,   0,   0,   0,   6, -11,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          10,          40, {   0,   0,   0,   0,   0,   0,   0,   5,   0,  -3,   0,   0,   0,   2 },  7, 14 }, //
        {          20,          30, {   0,   0,   0,   0,   0,   0,   0,   2,  -5,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         -30,          20, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   3,   0,   0,   0,   2 },  7, 14 }, //
        {           0,          50, {   0,   0,   0,   0,   0,   0,   0,   1,  -3,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          10,          40, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   2 },  9, 14 }, //
        {           0,         -40, {   5,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -40, {   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  1 }, //
        {           0,          40, {   4,   0,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -40, {   3,   1,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          40, {   3,   0,   2,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          40, {   3,  -1,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          40, {   2,   0,   2,  -1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -40, {   2,   0,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          40, {   2,  -2,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -10,          30, {   2,  -2,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -40, {   1,   2,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          40, {   1,   2,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          40, {   1,   1,   2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -10,          30, {   1,   1,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -40, {   1,   1,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -40, {   1,   1,   0,  -1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          40, {   1,   0,   4,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -40, {   1,   0,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -40, {   1,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -40, {   1,   0,   0,  -3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          40,           0, {   1,   0,  -1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          40, {   1,  -1,  -2,  -3,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          40, {   1,  -2,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -40, {   1,  -2,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -40, {   0,   2,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -40, {   0,   2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {         -10,          30, {   0,   2,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,          40, {   0,   0,   4,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,         -40, {   0,   0,   2,   0,   2,   0,   1,  -1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         -40, {   0,   0,   2,  -2,   1,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  2, 10 }, //
        {           0,         -40, {   0,   0,   2,  -2,   1,   0,   0,  -2,   0,   0,   2,   0,   0,   0 },  2, 11 }, //
        {          40,           0, {   0,   0,   2,  -2,   1,   0,   0,  -8,  11,   0,   0,   0,   0,   0 },  2,  9 }, //
        {           0,          40, {   0,   0,   2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {          40,           0, {   0,   0,   1,  -1,   2,   0,   0,  -1,   0,   2,   0,   0,   0,   0 },  2, 10 }, //
        {         -20,         -20, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,  -2,   0,   0,   0 },  2, 11 }, //
        {         -40,           0, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,  -1,   2,   0,   0,   0 },  2, 11 }, //
        {          20,         -20, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,  -2,   4,   0,   0,   0 },  2, 11 }, //
        {         -20,          20, {   0,   0,   0,   0,   2,   0,   0,  -1,   2,   0,   0,   0,   0,   0 },  4,  9 }, //
        {         -10,          30, {   0,   0,   0,   0,   1,   0,   0,  -8,  15,   0,   0,   0,   0,   0 },  4,  9 }, //
        {         -40,           0, {   0,   0,   0,   0,   0,   0,   8,  -8,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -40,           0, {   0,   0,   0,   0,   0,   0,   8, -10,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -30,          10, {   0,   0,   0,   0,   0,   0,   6, -10,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,          40, {   0,   0,   0,   0,   0,   0,   5,  -5,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {           0,         -40, {   0,   0,   0,   0,   0,   0,   5,  -9,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,         -40, {   0,   0,   0,   0,   0,   0,   4,  -2,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {         -40,           0, {   0,   0,   0,   0,   0,   0,   4,  -2,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {          40,           0, {   0,   0,   0,   0,   0,   0,   4,  -3,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {           0,         -40, {   0,   0,   0,   0,   0,   0,   3,  -4,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,          40, {   0,   0,   0,   0,   0,   0,   3,  -6,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,          40, {   0,   0,   0,   0,   0,   0,   2,  -6,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {          40,           0, {   0,   0,   0,   0,   0,   0,   0,   8, -15,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {           0,         -40, {   0,   0,   0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   0 },  7,  8 }, //
        {          10,          30, {   0,   0,   0,   0,   0,   0,   0,   6,  -5,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -40,           0, {   0,   0,   0,   0,   0,   0,   0,   5,  -2,   0,   0,   0,   0,   2 },  7, 14 }, //
        {           0,          40, {   0,   0,   0,   0,   0,   0,   0,   5,  -3,   0,   0,   0,   0,   2 },  7, 14 }, //
        {          20,          20, {   0,   0,   0,   0,   0,   0,   0,   2,   2,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -10,          30, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -2,   0,   0,   0,   2 },  7, 14 }, //
        {          40,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   2 }, 10, 14 }, //
        {         -10,         -20, {   2,   0,   2,   0,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {         -20,          10, {   2,   0,   0,  -2,  -1,   0,   0,  -6,   8,   0,   0,   0,   0,   0 },  0,  9 }, //
        {         -10,         -20, {   2,   0,  -1,  -1,   1,   0,   0,   3,  -7,   0,   0,   0,   0,   0 },  0,  9 }, //
        {          10,         -20, {   1,   0,   0,  -1,   1,   0,   0,  -3,   4,   0,   0,   0,   0,   0 },  0,  9 }, //
        {         -10,          20, {   1,   0,  -2,   0,  -2,   0, -10,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          20,         -10, {   0,   0,   2,  -2,   1,   0,   0,  -7,   9,   0,   0,   0,   0,   0 },  2,  9 }, //
        {          20,          10, {   0,   0,   1,  -1,   2,   0,   0,  -1,   0,  -2,   5,   0,   0,   0 },  2, 11 }, //
        {          20,          10, {   0,   0,   1,  -1,  -1,   0,   0,  -1,   0,  -1,   0,   0,   0,   0 },  2, 10 }, //
        {         -20,         -10, {   0,   0,   0,   0,   1,   0,   0,   1,   0,  -2,   0,   0,   0,   0 },  4, 10 }, //
        {         -20,          10, {   0,   0,   0,   0,   1,   0,   0,  -9,  17,   0,   0,   0,   0,   0 },  4,  9 }, //
        {         -10,         -20, {   0,   0,   0,   0,   0,   0,   2,  -3,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {          20,          10, {   0,   0,   0,   0,   0,   0,   1,  -2,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {          20,         -10, {   0,   0,   0,   0,   0,   0,   1,  -4,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   1 },  7, 14 }, //
        {         -20,         -10, {   0,   0,   0,   0,   0,   0,   0,   6, -10,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         -10,         -20, {   0,   0,   0,   0,   0,   0,   0,   5,  -8,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          20,         -10, {   0,   0,   0,   0,   0,   0,   0,   3,  -5,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {          20,          10, {   0,   0,   0,   0,   0,   0,   0,   2,  -6,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,          30, {   4,   0,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   3,   0,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   2,   2,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          30, {   2,   1,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   2,   1,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   2,   1,  -2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   2,   0,   4,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   2,   0,   2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          30, {   2,   0,   0,  -2,  -1,   0,   0,  -2,   0,   4,  -5,   0,   0,   0 },  0, 11 }, //
        {           0,          30, {   2,   0,   0,  -2,  -1,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         -30, {   2,   0,   0,  -2,  -2,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,          30, {   2,   0,   0,  -3,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   2,   0,  -1,  -1,  -1,   0,   0,  -1,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {          30,           0, {   2,   0,  -1,  -1,  -1,   0,   0,  -1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,          30, {   2,   0,  -2,  -6,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          30, {   2,   0,  -4,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   2,   0,  -4,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   2,  -1,   2,  -1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   2,  -1,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          30, {   2,  -1,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   2,  -2,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   1,   1,   4,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   1,   1,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   1,   0,   2,   3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          30, {   1,   0,   2,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          30, {   1,   0,   2,  -2,   2,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {          30,           0, {   1,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,          30, {   1,   0,   0,   4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   1,   0,   0,  -1,  -1,   0,   0,  -2,   2,   0,   0,   0,   0,   0 },  0,  9 }, //
        {           0,          30, {   1,   0,   0,  -6,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          30,           0, {   1,   0,  -1,   1,  -1,   0, -18,  17,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         -30, {   1,   0,  -1,  -1,  -1,   0,  20, -20,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,          30, {   1,   0,  -2,   0,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   1,   0,  -2,  -2,  -2,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         -30, {   1,  -1,   0,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          30, {   1,  -2,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          30, {   1,  -2,   0,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   1,  -2,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   1,  -2,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -30, {   0,   2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,          30, {   0,   2,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -30, {   0,   1,   4,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,          30, {   0,   1,   2,   3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -30, {   0,   1,   0,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,          30, {   0,   1,   0,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -30, {   0,   0,   4,  -2,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,         -30, {   0,   0,   2,   3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,          30, {   0,   0,   2,   0,   2,   0,   0,   1,   0,  -1,   0,   0,   0,   0 },  2, 10 }, //
        {           0,         -30, {   0,   0,   2,   0,   2,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  2, 10 }, //
        {           0,          30, {   0,   0,   2,   0,   2,   0,  -1,   1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         -30, {   0,   0,   2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,          30, {   0,   0,   2,  -2,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,         -30, {   0,   0,   2,  -2,   1,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  2, 10 }, //
        {         -30,           0, {   0,   0,   2,  -2,  -1,   0,  -5,   6,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          30, {   0,   0,   1,  -1,   2,   0,   0,   0,  -2,   0,   0,   0,   0,   0 },  2,  9 }, //
        {          30,           0, {   0,   0,   1,  -1,   2,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  2, 10 }, //
        {          30,           0, {   0,   0,   1,  -1,   1,   0,   1,  -2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          30,           0, {   0,   0,   1,  -1,   1,   0,  -2,   1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          30, {   0,   0,   0,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {           0,          30, {   0,   0,   0,   1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {         -30,           0, {   0,   0,   0,   0,   2,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  4, 10 }, //
        {         -30,           0, {   0,   0,   0,   0,   2,   0,   0,  -4,   8,  -3,   0,   0,   0,   0 },  4, 10 }, //
        {          30,           0, {   0,   0,   0,   0,   1,   0,   5,  -8,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {           0,         -30, {   0,   0,   0,   0,   1,   0,   2,  -2,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {          30,           0, {   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,  -1,   0,   0,   0 },  4, 11 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   9, -11,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   8, -16,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   5,  -3,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   0,   6,  -7,   0,   0,   0,   0,   2 },  7, 14 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,  -2,   0,   0,   2 },  7, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   4,  -8,   1,   5,   0,   0,  -2 },  7, 14 }, //
        {         -30,           0, {   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,  -2,   0,   0,   2 },  7, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -1,   0,   0,   0,   1 },  7, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -3,   0,   0,   0,  -1 },  7, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   1,  -6,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,         -30, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,  -5,   0,   0,   2 },  9, 14 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   0,   0,   2 }, 10, 14 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   2 }, 11, 14 }, //
        {          30,           0, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   1 }, 11, 14 }, //
        {           0,          30, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2 }, 12, 14 }, //
        {           0,         -20, {   4,   1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   4,   0,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   4,  -1,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   4,  -1,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   3,   1,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   3,   0,   4,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   3,   0,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   3,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {           0,         -20, {   3,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,          20, {   3,   0,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   3,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   3,   0,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   3,   0,  -2,  -1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   3,   0,  -2,  -6,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   2,   2,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   2,   1,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   2,   1,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   2,   1,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   2,   1,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -20, {   2,   1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {           0,          20, {   2,   1,  -2,  -6,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   2,   0,   4,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   2,   0,   2,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   2,   0,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -20, {   2,   0,   2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   2,   0,   2,  -3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          20,           0, {   2,   0,   2,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,          20, {   2,   0,   2,  -6,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   2,   0,   0,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   2,   0,   0,  -1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   2,   0,   0,  -2,   1,   0,   0,  -5,   6,   0,   0,   0,   0,   0 },  0,  9 }, //
        {           0,         -20, {   2,   0,   0,  -2,  -1,   0,   0,  -2,   0,   3,  -1,   0,   0,   0 },  0, 11 }, //
        {           0,         -20, {   2,   0,   0,  -3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   2,   0,   0,  -6,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          20,           0, {   2,   0,  -1,  -1,  -2,   0,   0,  -1,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {           0,         -20, {   2,   0,  -2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   2,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,          20, {   2,   0,  -4,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   2,  -1,   0,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   2,  -1,   0,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   2,  -1,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   2,  -1,  -2,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   2,  -2,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   2,  -2,   0,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   1,   2,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   1,   2,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   1,   2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -20, {   1,   1,   2,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   1,   1,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   1,   1,   0,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   1,   1,  -2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   1,   1,  -2,  -3,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   1,   1,  -2,  -6,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   1,   0,   4,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {         -20,           0, {   1,   0,   3,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   1,   0,   2,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   1,   0,   2,  -6,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          20,           0, {   1,   0,   1,   1,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         -20, {   1,   0,   0,  -1,   1,   0,   0,  -1,   0,   1,   0,   0,   0,   0 },  0, 10 }, //
        {           0,          20, {   1,   0,   0,  -1,  -1,   0,   0,  -3,   4,   0,   0,   0,   0,   0 },  0,  9 }, //
        {           0,         -20, {   1,   0,   0,  -2,   1,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {           0,          20, {   1,   0,   0,  -2,  -1,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {           0,          20, {   1,   0,   0,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,          20, {   1,   0,   0,  -3,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          20,           0, {   1,   0,  -1,   1,  -1,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,          20, {   1,   0,  -1,   0,  -1,   0,  -3,   5,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          20,           0, {   1,   0,  -1,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   1,   0,  -2,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   1,   0,  -2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   1,   0,  -2,  -2,  -2,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {           0,          20, {   1,   0,  -2,  -6,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   1,   0,  -4,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   1,  -1,   2,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   1,  -1,   2,   1,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   1,  -1,   2,  -3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   1,  -1,   0,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   1,  -1,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   1,  -1,  -2,   1,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -20, {   1,  -1,  -2,  -4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   1,  -1,  -4,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   1,  -2,   2,   2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {          10,         -10, {   1,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,          20, {   1,  -2,  -2,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          20, {   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  2 }, //
        {           0,          20, {   0,   3,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -20, {   0,   2,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -20, {   0,   1,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {           0,         -20, {   0,   1,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -20, {   0,   1,   0,   4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -20, {   0,   1,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {           0,         -20, {   0,   1,  -2,   4,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -20, {   0,   0,   4,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,          20, {   0,   0,   2,  -2,   2,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  2, 10 }, //
        {          20,           0, {   0,   0,   2,  -2,   1,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  2, 10 }, //
        {           0,          20, {   0,   0,   2,  -2,   1,   0,   0,   1,   0,  -1,   0,   0,   0,   0 },  2, 10 }, //
        {           0,          20, {   0,   0,   2,  -2,   1,   0,   0,  -2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         -20, {   0,   0,   2,  -2,   1,   0,   0,  -3,   0,   3,   0,   0,   0,   0 },  2, 10 }, //
        {          20,           0, {   0,   0,   2,  -2,   1,   0,   0,  -4,   8,  -3,   0,   0,   0,   0 },  2, 10 }, //
        {           0,         -20, {   0,   0,   2,  -2,   1,   0,   0,  -4,   4,   0,   0,   0,   0,   0 },  2,  9 }, //
        {           0,         -20, {   0,   0,   2,  -2,   1,   0,  -5,   5,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          20,           0, {   0,   0,   2,  -2,   1,   0,  -8,  11,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -20,           0, {   0,   0,   1,   1,   2,   0,   0,   1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          20, {   0,   0,   1,  -1,   2,   0,   0,  -1,   0,   0,   1,   0,   0,   0 },  2, 11 }, //
        {         -20,           0, {   0,   0,   1,  -1,   2,   0,   0,  -1,   0,  -1,   0,   0,   0,   0 },  2, 10 }, //
        {           0,          20, {   0,   0,   1,  -1,   2,   0,  -5,   7,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          20, {   0,   0,   1,  -1,   2,   0,  -8,  12,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          20, {   0,   0,   1,  -1,   1,   0,   1,  -3,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         -20, {   0,   0,   1,  -1,   1,   0,   0,   1,  -4,   0,   0,   0,   0,   0 },  2,  9 }, //
        {          20,           0, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   1,  -3,   0,   0,   0 },  2, 11 }, //
        {          20,           0, {   0,   0,   1,  -1,   1,   0,   0,  -1,   0,   0,   0,  -1,   0,   0 },  2, 12 }, //
        {           0,         -20, {   0,   0,   1,  -1,   1,   0,   0,  -4,   6,   0,   0,   0,   0,   0 },  2,  9 }, //
        {          20,           0, {   0,   0,   1,  -1,   1,   0,  -5,   6,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {         -20,           0, {   0,   0,   0,   0,   1,   0,   3,  -4,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {           0,          20, {   0,   0,   0,   0,   1,   0,   0,   7, -13,   0,   0,   0,   0,   0 },  4,  9 }, //
        {           0,          20, {   0,   0,   0,   0,   1,   0,   0,   2,   0,  -2,   0,   0,   0,   0 },  4, 10 }, //
        {           0,         -20, {   0,   0,   0,   0,   1,   0,   0,   2,  -2,   0,   0,   0,   0,   0 },  4,  9 }, //
        {           0,         -20, {   0,   0,   0,   0,   1,   0,   0,  -2,   2,   0,   0,   0,   0,   0 },  4,  9 }, //
        {           0,         -20, {   0,   0,   0,   0,   1,   0,  -2,   2,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {          20,           0, {   0,   0,   0,   0,   1,   0,  -3,   4,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {           0,          20, {   0,   0,   0,   0,   0,   0,   8, -12,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,         -20, {   0,   0,   0,   0,   0,   0,   7, -10,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {          20,           0, {   0,   0,   0,   0,   0,   0,   7, -11,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -20,           0, {   0,   0,   0,   0,   0,   0,   6,  -4,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {         -20,           0, {   0,   0,   0,   0,   0,   0,   6,  -6,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {         -20,           0, {   0,   0,   0,   0,   0,   0,   5,  -5,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {           0,         -20, {   0,   0,   0,   0,   0,   0,   5,  -6,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {         -20,           0, {   0,   0,   0,   0,   0,   0,   4,  -2,   0,   0,   0,   0,   0,   0 },  6,  8 }, //
        {           0,         -20, {   0,   0,   0,   0,   0,   0,   4,  -5,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {          20,           0, {   0,   0,   0,   0,   0,   0,   4,  -5,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,         -20, {   0,   0,   0,   0,   0,   0,   3,  -4,   0,   0,   0,   0,   0,   1 },  6, 14 }, //
        {          20,           0, {   0,   0,   0,   0,   0,   0,   3,  -4,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         -20,           0, {   0,   0,   0,   0,   0,   0,   3,  -8,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,          20, {   0,   0,   0,   0,   0,   0,   2,  -5,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,          20, {   0,   0,   0,   0,   0,   0,   1,  -2,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,          20, {   0,   0,   0,   0,   0,   0,   1,  -4,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,         -20, {   0,   0,   0,   0,   0,   0,   0,   9, -17,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {         -20,           0, {   0,   0,   0,   0,   0,   0,   0,   7,  -8,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -20,           0, {   0,   0,   0,   0,   0,   0,   0,   7,  -9,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -20,           0, {   0,   0,   0,   0,   0,   0,   0,   5,  -6,   0,   0,   0,   0,   2 },  7, 14 }, //
        {          20,           0, {   0,   0,   0,   0,   0,   0,   0,   5, -10,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,          20, {   0,   0,   0,   0,   0,   0,   0,   4,   0,  -4,   0,   0,   0,   2 },  7, 14 }, //
        {           0,         -20, {   0,   0,   0,   0,   0,   0,   0,   4,  -6,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,         -20, {   0,   0,   0,   0,   0,   0,   0,   4,  -7,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {           0,         -20, {   0,   0,   0,   0,   0,   0,   0,   4,  -8,   3,   0,   0,   0,   1 },  7, 14 }, //
        {           0,          20, {   0,   0,   0,   0,   0,   0,   0,   4,  -8,   3,   0,   0,   0,  -1 },  7, 14 }, //
        {          20,           0, {   0,   0,   0,   0,   0,   0,   0,   4,  -8,   1,   5,   0,   0,   2 },  7, 14 }, //
        {          20,           0, {   0,   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   2 },  7, 14 }, //
        {           0,          20, {   0,   0,   0,   0,   0,   0,   0,   3,  -8,   3,   0,   0,   0,  -2 },  7, 14 }, //
        {          10,         -10, {   0,   0,   0,   0,   0,   0,   0,   2,   1,   0,   0,   0,   0,   2 },  7, 14 }, //
        {          20,           0, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,  -2,   0,   0,   1 },  7, 14 }, //
        {           0,         -20, {   0,   0,   0,   0,   0,   0,   0,   2,   0,  -5,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,         -20, {   0,   0,   0,   0,   0,   0,   0,   2,  -4,   0,   0,   0,   0,   1 },  7, 14 }, //
        {          20,           0, {   0,   0,   0,   0,   0,   0,   0,   2,  -7,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          20,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   1,   0,   0,   0,   1 },  7, 14 }, //
        {           0,          20, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {          20,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -1,   0,   0,   0,  -1 },  7, 14 }, //
        {          20,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -2,   5,   0,   0,   2 },  7, 14 }, //
        {           0,          20, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -2,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,         -20, {   0,   0,   0,   0,   0,   0,   0,   1,   0,  -5,   0,   0,   0,  -2 },  7, 14 }, //
        {         -20,           0, {   0,   0,   0,   0,   0,   0,   0,   7,  -7,   0,   0,   0,   0,   2 },  7, 14 }, //
        {           0,          10, {   5,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   4,   1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   3,   1,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          10, {   3,   1,  -2,  -6,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   3,   0,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   3,   0,   0,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -10, {   3,   0,  -2,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   3,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  2 }, //
        {           0,          10, {   2,   2,   0,  -2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          10, {   2,   1,   2,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          10, {   2,   1,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   2,   0,   2,  -2,   2,   0,   0,  -2,   0,   3,   0,   0,   0,   0 },  0, 10 }, //
        {          10,           0, {   2,   0,   1,  -3,   1,   0,  -6,   7,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,          10, {   2,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -10, {   2,   0,   0,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          10, {   2,   0,   0,  -4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   2,   0,   0,  -6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,          10, {   2,   0,  -2,  -2,  -2,   0,   0,  -2,   0,   2,   0,   0,   0,   0 },  0, 10 }, //
        {           0,         -10, {   2,   0,  -2,  -5,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          10, {   2,  -1,   2,   4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   2,  -1,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -10, {   2,  -1,   0,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   2,  -1,  -2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   2,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  3 }, //
        {           0,          10, {   2,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,          10, {   1,   3,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          10, {   1,   2,   2,  -4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   1,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,          10, {   1,   1,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          10, {   1,   1,  -2,   1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   1,   1,  -2,  -1,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   1,   1,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -10, {   1,   0,   2,   0,   2,   0,   1,  -1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {          10,           0, {   1,   0,   2,   0,   2,   0,   0,   4,  -8,   3,   0,   0,   0,   0 },  0, 10 }, //
        {          10,           0, {   1,   0,   2,   0,   2,   0,   0,  -4,   8,  -3,   0,   0,   0,   0 },  0, 10 }, //
        {           0,          10, {   1,   0,   2,   0,   2,   0,  -1,   1,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,          10, {   1,   0,   2,  -2,   2,   0,  -3,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         -10, {   1,   0,   0,   0,   1,   0, -10,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,          10, {   1,   0,   0,   0,  -1,   0, -10,   3,   0,   0,   0,   0,   0,   0 },  0,  8 }, //
        {           0,         -10, {   1,   0,   0,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   1,   0,   0,  -6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -10, {   1,   0,  -2,   4,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,          10, {   1,   0,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -10, {   1,   0,  -2,  -2,  -2,   0,   0,   1,   0,  -1,   0,   0,   0,   0 },  0, 10 }, //
        {           0,         -10, {   1,   0,  -2,  -2,  -3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -10, {   1,   0,  -2,  -4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  4 }, //
        {           0,         -10, {   0,   2,   0,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,          10, {   0,   1,   4,  -4,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -10, {   0,   1,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  4 }, //
        {           0,          10, {   0,   1,  -4,   2,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -10, {   0,   0,   2,   2,   2,   0,   0,   2,   0,  -2,   0,   0,   0,   0 },  2, 10 }, //
        {           0,         -10, {   0,   0,   2,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,          10, {   0,   0,   2,   0,   2,   0,   2,  -2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          10,           0, {   0,   0,   2,   0,   2,   0,   2,  -3,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          10,           0, {   0,   0,   2,   0,   2,   0,  -2,   3,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         -10, {   0,   0,   2,   0,   2,   0,  -2,   2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         -10, {   0,   0,   2,  -2,   1,   0,   1,  -1,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          10, {   0,   0,   2,  -2,   1,   0,   0,  -2,   0,   1,   0,   0,   0,   0 },  2, 10 }, //
        {           0,          10, {   0,   0,   2,  -2,   1,   0,   0, -10,  15,   0,   0,   0,   0,   0 },  2,  9 }, //
        {           0,          10, {   0,   0,   1,  -1,   2,   0,   0,  -1,   0,   0,  -1,   0,   0,   0 },  2, 11 }, //
        {         -10,           0, {   0,   0,   1,  -1,   2,   0,  -3,   4,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {          10,           0, {   0,   0,   1,  -1,   1,   0,  -1,   2,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         -10, {   0,   0,   1,  -1,   1,   0,  -4,   6,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,          10, {   0,   0,   1,  -1,  -1,   0,  -5,   7,   0,   0,   0,   0,   0,   0 },  2,  8 }, //
        {           0,         -10, {   0,   0,   0,   3,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  3,  5 }, //
        {         -10,           0, {   0,   0,   0,   0,   2,   0,   0,   0,   0,   1,   0,   0,   0,   0 },  4, 10 }, //
        {           0,         -10, {   0,   0,   0,   0,   2,   0,  -3,   5,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {          10,           0, {   0,   0,   0,   0,   1,   0,   0,  -1,   0,   2,   0,   0,   0,   0 },  4, 10 }, //
        {          10,           0, {   0,   0,   0,   0,   1,   0,  -1,   2,   0,   0,   0,   0,   0,   0 },  4,  8 }, //
        {           0,          10, {   0,   0,   0,   0,   0,   0,   9, -13,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,         -10, {   0,   0,   0,   0,   0,   0,   8, -11,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,          10, {   0,   0,   0,   0,   0,   0,   8, -14,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,         -10, {   0,   0,   0,   0,   0,   0,   6,  -7,   0,   0,   0,   0,   0,  -1 },  6, 14 }, //
        {           0,         -10, {   0,   0,   0,   0,   0,   0,   5,  -3,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {          10,           0, {   0,   0,   0,   0,   0,   0,   5,  -4,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {          10,           0, {   0,   0,   0,   0,   0,   0,   5,  -6,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {           0,          10, {   0,   0,   0,   0,   0,   0,   4,  -8,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         -10,           0, {   0,   0,   0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   2 },  6, 14 }, //
        {           0,          10, {   0,   0,   0,   0,   0,   0,   3,  -3,   0,   2,   0,   0,   0,   2 },  6, 14 }, //
        {           0,          10, {   0,   0,   0,   0,   0,   0,   1,  -1,   0,   0,   0,   0,   0,  -2 },  6, 14 }, //
        {         -10,           0, {   0,   0,   0,   0,   0,   0,   0,   7, -12,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,          10, {   0,   0,   0,   0,   0,   0,   0,   6,  -4,   0,   0,   0,   0,   2 },  7, 14 }, //
        {         -10,           0, {   0,   0,   0,   0,   0,   0,   0,   6,  -8,   1,   5,   0,   0,   2 },  7, 14 }, //
        {           0,         -10, {   0,   0,   0,   0,   0,   0,   0,   6,  -9,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,          10, {   0,   0,   0,   0,   0,   0,   0,   5,   0,  -4,   0,   0,   0,   2 },  7, 14 }, //
        {           0,         -10, {   0,   0,   0,   0,   0,   0,   0,   5,  -7,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,          10, {   0,   0,   0,   0,   0,   0,   0,   5,  -8,   3,   0,   0,   0,   2 },  7, 14 }, //
        {           0,         -10, {   0,   0,   0,   0,   0,   0,   0,   5,  -9,   0,   0,   0,   0,  -1 },  7, 14 }, //
        {           0,         -10, {   0,   0,   0,   0,   0,   0,   0,   5, -13,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,          10, {   0,   0,   0,   0,   0,   0,   0,   5, -16,   4,   5,   0,   0,  -2 },  7, 14 }, //
        {           0,         -10, {   0,   0,   0,   0,   0,   0,   0,   3,   0,  -5,   0,   0,   0,  -2 },  7, 14 }, //
        {          10,           0, {   0,   0,   0,   0,   0,   0,   0,   3,  -7,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {          10,           0, {   0,   0,   0,   0,   0,   0,   0,   3,  -9,   0,   0,   0,   0,  -2 },  7, 14 }, //
        {           0,         -10, {   0,   0,   0,   0,   0,   0,   0,   2,   0,   2,   0,   0,   0,   2 },  7, 14 }, //
        {          10,           0, {   0,   0,   0,   0,   0,   0,   0,   2,  -8,   1,   5,   0,   0,  -2 },  7, 14 }, //
        {         -10,           0, {   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   2,   0,   0,   2 },  7, 14 }, //
        {           0,         -10, {   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2 }, 13, 14 }  //
};

static const nutation_terms B1[19] = { //
        {          20,       88303, {   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  4,  5 }, //
        {         -30,      -30309, {   0,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,       -6770, {   0,   1,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {         -10,       -4877, {   0,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,        4725, {   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  4,  5 }, //
        {          10,        2990, {   0,   1,  -2,   2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {          50,       -1840, {   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  2 }, //
        {           0,        -630, {   1,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -420, {   0,   2,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         320, {   1,   0,  -2,   0,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         180, {   0,   0,   2,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,        -110, {   2,   0,   2,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -110, {   1,   0,  -2,  -2,  -2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,        -110, {   0,   0,   2,   2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,        -100, {   2,   0,  -2,   0,  -1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         100, {   1,   0,   2,  -2,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  0,  5 }, //
        {           0,         -90, {   0,   0,   2,  -2,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  2,  5 }, //
        {           0,         -20, {   0,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  5 }, //
        {           0,         -10, {   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 },  1,  2 }  //
};
