/* -LICENSE-START-
 ** Copyright (c) 2024 Blackmagic Design
 **  
 ** Permission is hereby granted, free of charge, to any person or organization 
 ** obtaining a copy of the software and accompanying documentation (the 
 ** "Software") to use, reproduce, display, distribute, sub-license, execute, 
 ** and transmit the Software, and to prepare derivative works of the Software, 
 ** and to permit third-parties to whom the Software is furnished to do so, in 
 ** accordance with:
 ** 
 ** (1) if the Software is obtained from Blackmagic Design, the End User License 
 ** Agreement for the Software Development Kit ("EULA") available at 
 ** https://www.blackmagicdesign.com/EULA/DeckLinkSDK; or
 ** 
 ** (2) if the Software is obtained from any third party, such licensing terms 
 ** as notified by that third party,
 ** 
 ** and all subject to the following:
 ** 
 ** (3) the copyright notices in the Software and this entire statement, 
 ** including the above license grant, this restriction and the following 
 ** disclaimer, must be included in all copies of the Software, in whole or in 
 ** part, and all derivative works of the Software, unless such copies or 
 ** derivative works are solely in the form of machine-executable object code 
 ** generated by a source language processor.
 ** 
 ** (4) THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 ** OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 ** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
 ** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
 ** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
 ** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 ** DEALINGS IN THE SOFTWARE.
 ** 
 ** A copy of the Software is available free of charge at 
 ** https://www.blackmagicdesign.com/desktopvideo_sdk under the EULA.
 ** 
 ** -LICENSE-END-
 */


/*
 * -- AUTOMATICALLY GENERATED - DO NOT EDIT ---
 */

#ifndef BMD_DECKLINKAPI_H
#define BMD_DECKLINKAPI_H


#ifndef BMD_CONST
    #if defined(_MSC_VER)
        #define BMD_CONST __declspec(selectany) static const
    #else
        #define BMD_CONST static const
    #endif
#endif

#ifndef BMD_PUBLIC
	#define BMD_PUBLIC
#endif

/* DeckLink API */

#include <CoreFoundation/CoreFoundation.h>
#include <CoreFoundation/CFPlugInCOM.h>
#include <stdint.h>

#include "DeckLinkAPITypes.h"
#include "DeckLinkAPIModes.h"
#include "DeckLinkAPIDiscovery.h"
#include "DeckLinkAPIConfiguration.h"
#include "DeckLinkAPIDeckControl.h"

#include "DeckLinkAPIStreaming.h"

#define BLACKMAGIC_DECKLINK_API_MAGIC	1

// Type Declarations


// Interface ID Declarations

BMD_CONST REFIID IID_IDeckLinkVideoOutputCallback                 = /* 5BE6DF26-02CE-433E-99D9-9A87C3AC171F */ { 0x5B,0xE6,0xDF,0x26,0x02,0xCE,0x43,0x3E,0x99,0xD9,0x9A,0x87,0xC3,0xAC,0x17,0x1F };
BMD_CONST REFIID IID_IDeckLinkInputCallback                       = /* 3A94F075-C37D-4BA8-BCC0-1D778C8F881B */ { 0x3A,0x94,0xF0,0x75,0xC3,0x7D,0x4B,0xA8,0xBC,0xC0,0x1D,0x77,0x8C,0x8F,0x88,0x1B };
BMD_CONST REFIID IID_IDeckLinkEncoderInputCallback                = /* ACF13E61-F4A0-4974-A6A7-59AFF6268B31 */ { 0xAC,0xF1,0x3E,0x61,0xF4,0xA0,0x49,0x74,0xA6,0xA7,0x59,0xAF,0xF6,0x26,0x8B,0x31 };
BMD_CONST REFIID IID_IDeckLinkVideoBufferAllocator                = /* 3481A4DF-2B11-4E55-AC61-836B87985E9A */ { 0x34,0x81,0xA4,0xDF,0x2B,0x11,0x4E,0x55,0xAC,0x61,0x83,0x6B,0x87,0x98,0x5E,0x9A };
BMD_CONST REFIID IID_IDeckLinkVideoBufferAllocatorProvider        = /* 08B80403-BFF2-49D0-B448-8C908B9E9FC9 */ { 0x08,0xB8,0x04,0x03,0xBF,0xF2,0x49,0xD0,0xB4,0x48,0x8C,0x90,0x8B,0x9E,0x9F,0xC9 };
BMD_CONST REFIID IID_IDeckLinkAudioOutputCallback                 = /* 403C681B-7F46-4A12-B993-2BB127084EE6 */ { 0x40,0x3C,0x68,0x1B,0x7F,0x46,0x4A,0x12,0xB9,0x93,0x2B,0xB1,0x27,0x08,0x4E,0xE6 };
BMD_CONST REFIID IID_IDeckLinkIterator                            = /* 50FB36CD-3063-4B73-BDBB-958087F2D8BA */ { 0x50,0xFB,0x36,0xCD,0x30,0x63,0x4B,0x73,0xBD,0xBB,0x95,0x80,0x87,0xF2,0xD8,0xBA };
BMD_CONST REFIID IID_IDeckLinkAPIInformation                      = /* 7BEA3C68-730D-4322-AF34-8A7152B532A4 */ { 0x7B,0xEA,0x3C,0x68,0x73,0x0D,0x43,0x22,0xAF,0x34,0x8A,0x71,0x52,0xB5,0x32,0xA4 };
BMD_CONST REFIID IID_IDeckLinkIPFlowAttributes                    = /* CDA938DA-6479-40C6-B2EC-A3579B3AEECD */ { 0xCD,0xA9,0x38,0xDA,0x64,0x79,0x40,0xC6,0xB2,0xEC,0xA3,0x57,0x9B,0x3A,0xEE,0xCD };
BMD_CONST REFIID IID_IDeckLinkIPFlowStatus                        = /* 31C41656-4992-4396-BBE9-5F8406AAB5AF */ { 0x31,0xC4,0x16,0x56,0x49,0x92,0x43,0x96,0xBB,0xE9,0x5F,0x84,0x06,0xAA,0xB5,0xAF };
BMD_CONST REFIID IID_IDeckLinkIPFlowSetting                       = /* 86DD9174-27D3-4032-B2AD-6067C3BB2424 */ { 0x86,0xDD,0x91,0x74,0x27,0xD3,0x40,0x32,0xB2,0xAD,0x60,0x67,0xC3,0xBB,0x24,0x24 };
BMD_CONST REFIID IID_IDeckLinkIPFlow                              = /* C5FC83C7-5B8E-42A7-9A40-7C065955D4E1 */ { 0xC5,0xFC,0x83,0xC7,0x5B,0x8E,0x42,0xA7,0x9A,0x40,0x7C,0x06,0x59,0x55,0xD4,0xE1 };
BMD_CONST REFIID IID_IDeckLinkIPFlowIterator                      = /* BD296AB2-A5C5-4153-888F-AAB1FDBD8A5C */ { 0xBD,0x29,0x6A,0xB2,0xA5,0xC5,0x41,0x53,0x88,0x8F,0xAA,0xB1,0xFD,0xBD,0x8A,0x5C };
BMD_CONST REFIID IID_IDeckLinkOutput                              = /* 1A8077F1-9FE2-4533-8147-2294305E253F */ { 0x1A,0x80,0x77,0xF1,0x9F,0xE2,0x45,0x33,0x81,0x47,0x22,0x94,0x30,0x5E,0x25,0x3F };
BMD_CONST REFIID IID_IDeckLinkMacOutput                           = /* 22EFC84B-6981-4D35-9F9A-9CEC5790107E */ { 0x22,0xEF,0xC8,0x4B,0x69,0x81,0x4D,0x35,0x9F,0x9A,0x9C,0xEC,0x57,0x90,0x10,0x7E };
BMD_CONST REFIID IID_IDeckLinkInput                               = /* 4095DB82-E294-4B8C-AAA8-3B9E80C49336 */ { 0x40,0x95,0xDB,0x82,0xE2,0x94,0x4B,0x8C,0xAA,0xA8,0x3B,0x9E,0x80,0xC4,0x93,0x36 };
BMD_CONST REFIID IID_IDeckLinkIPExtensions                        = /* 46CF7903-A9FD-4D0B-8FFC-0103722AB442 */ { 0x46,0xCF,0x79,0x03,0xA9,0xFD,0x4D,0x0B,0x8F,0xFC,0x01,0x03,0x72,0x2A,0xB4,0x42 };
BMD_CONST REFIID IID_IDeckLinkHDMIInputEDID                       = /* ABBBACBC-45BC-4665-9D92-ACE6E5A97902 */ { 0xAB,0xBB,0xAC,0xBC,0x45,0xBC,0x46,0x65,0x9D,0x92,0xAC,0xE6,0xE5,0xA9,0x79,0x02 };
BMD_CONST REFIID IID_IDeckLinkEncoderInput                        = /* 46C1332E-6FD9-472A-8591-FE59C22192E1 */ { 0x46,0xC1,0x33,0x2E,0x6F,0xD9,0x47,0x2A,0x85,0x91,0xFE,0x59,0xC2,0x21,0x92,0xE1 };
BMD_CONST REFIID IID_IDeckLinkVideoBuffer                         = /* CCB4B64A-5C86-4E02-B778-885D352709FE */ { 0xCC,0xB4,0xB6,0x4A,0x5C,0x86,0x4E,0x02,0xB7,0x78,0x88,0x5D,0x35,0x27,0x09,0xFE };
BMD_CONST REFIID IID_IDeckLinkMacVideoBuffer                      = /* 3FBEDC55-AA43-4EAB-B12F-FA1299C7C324 */ { 0x3F,0xBE,0xDC,0x55,0xAA,0x43,0x4E,0xAB,0xB1,0x2F,0xFA,0x12,0x99,0xC7,0xC3,0x24 };
BMD_CONST REFIID IID_IDeckLinkVideoFrame                          = /* 6502091C-615F-4F51-BAF6-45C4256DD5B0 */ { 0x65,0x02,0x09,0x1C,0x61,0x5F,0x4F,0x51,0xBA,0xF6,0x45,0xC4,0x25,0x6D,0xD5,0xB0 };
BMD_CONST REFIID IID_IDeckLinkMutableVideoFrame                   = /* CF9EB134-0374-4C5B-95FA-1EC14819FF62 */ { 0xCF,0x9E,0xB1,0x34,0x03,0x74,0x4C,0x5B,0x95,0xFA,0x1E,0xC1,0x48,0x19,0xFF,0x62 };
BMD_CONST REFIID IID_IDeckLinkVideoFrame3DExtensions              = /* D4DBE9C6-B4D2-49D3-ABF2-B4E86C7391B0 */ { 0xD4,0xDB,0xE9,0xC6,0xB4,0xD2,0x49,0xD3,0xAB,0xF2,0xB4,0xE8,0x6C,0x73,0x91,0xB0 };
BMD_CONST REFIID IID_IDeckLinkVideoFrameMetadataExtensions        = /* E232A5B7-4DB4-44C9-9152-F47C12E5F051 */ { 0xE2,0x32,0xA5,0xB7,0x4D,0xB4,0x44,0xC9,0x91,0x52,0xF4,0x7C,0x12,0xE5,0xF0,0x51 };
BMD_CONST REFIID IID_IDeckLinkVideoFrameMutableMetadataExtensions = /* CC198FC6-8298-4419-942D-8357EC355E58 */ { 0xCC,0x19,0x8F,0xC6,0x82,0x98,0x44,0x19,0x94,0x2D,0x83,0x57,0xEC,0x35,0x5E,0x58 };
BMD_CONST REFIID IID_IDeckLinkVideoInputFrame                     = /* C9ADD3D2-BE52-488D-AB2D-7FDEF7AF0C95 */ { 0xC9,0xAD,0xD3,0xD2,0xBE,0x52,0x48,0x8D,0xAB,0x2D,0x7F,0xDE,0xF7,0xAF,0x0C,0x95 };
BMD_CONST REFIID IID_IDeckLinkAncillaryPacket                     = /* CC5BBF7E-029C-4D3B-9158-6000EF5E3670 */ { 0xCC,0x5B,0xBF,0x7E,0x02,0x9C,0x4D,0x3B,0x91,0x58,0x60,0x00,0xEF,0x5E,0x36,0x70 };
BMD_CONST REFIID IID_IDeckLinkAncillaryPacketIterator             = /* 3FC8994B-88FB-4C17-968F-9AAB69D964A7 */ { 0x3F,0xC8,0x99,0x4B,0x88,0xFB,0x4C,0x17,0x96,0x8F,0x9A,0xAB,0x69,0xD9,0x64,0xA7 };
BMD_CONST REFIID IID_IDeckLinkVideoFrameAncillaryPackets          = /* 6C186C0F-459E-41D8-AEE2-4812D81AEE68 */ { 0x6C,0x18,0x6C,0x0F,0x45,0x9E,0x41,0xD8,0xAE,0xE2,0x48,0x12,0xD8,0x1A,0xEE,0x68 };
BMD_CONST REFIID IID_IDeckLinkVideoFrameAncillary                 = /* 732E723C-D1A4-4E29-9E8E-4A88797A0004 */ { 0x73,0x2E,0x72,0x3C,0xD1,0xA4,0x4E,0x29,0x9E,0x8E,0x4A,0x88,0x79,0x7A,0x00,0x04 };
BMD_CONST REFIID IID_IDeckLinkEncoderPacket                       = /* B693F36C-316E-4AF1-B6C2-F389A4BCA620 */ { 0xB6,0x93,0xF3,0x6C,0x31,0x6E,0x4A,0xF1,0xB6,0xC2,0xF3,0x89,0xA4,0xBC,0xA6,0x20 };
BMD_CONST REFIID IID_IDeckLinkEncoderVideoPacket                  = /* 4E7FD944-E8C7-4EAC-B8C0-7B77F80F5AE0 */ { 0x4E,0x7F,0xD9,0x44,0xE8,0xC7,0x4E,0xAC,0xB8,0xC0,0x7B,0x77,0xF8,0x0F,0x5A,0xE0 };
BMD_CONST REFIID IID_IDeckLinkEncoderAudioPacket                  = /* 49E8EDC8-693B-4E14-8EF6-12C658F5A07A */ { 0x49,0xE8,0xED,0xC8,0x69,0x3B,0x4E,0x14,0x8E,0xF6,0x12,0xC6,0x58,0xF5,0xA0,0x7A };
BMD_CONST REFIID IID_IDeckLinkH265NALPacket                       = /* 639C8E0B-68D5-4BDE-A6D4-95F3AEAFF2E7 */ { 0x63,0x9C,0x8E,0x0B,0x68,0xD5,0x4B,0xDE,0xA6,0xD4,0x95,0xF3,0xAE,0xAF,0xF2,0xE7 };
BMD_CONST REFIID IID_IDeckLinkAudioInputPacket                    = /* E43D5870-2894-11DE-8C30-0800200C9A66 */ { 0xE4,0x3D,0x58,0x70,0x28,0x94,0x11,0xDE,0x8C,0x30,0x08,0x00,0x20,0x0C,0x9A,0x66 };
BMD_CONST REFIID IID_IDeckLinkScreenPreviewCallback               = /* D4FA2345-9FBA-4497-95C3-C0C3CED3CDA8 */ { 0xD4,0xFA,0x23,0x45,0x9F,0xBA,0x44,0x97,0x95,0xC3,0xC0,0xC3,0xCE,0xD3,0xCD,0xA8 };
BMD_CONST REFIID IID_IDeckLinkCocoaScreenPreviewCallback          = /* 91945B73-70DE-40A9-A25D-EA00397D0D3A */ { 0x91,0x94,0x5B,0x73,0x70,0xDE,0x40,0xA9,0xA2,0x5D,0xEA,0x00,0x39,0x7D,0x0D,0x3A };
BMD_CONST REFIID IID_IDeckLinkGLScreenPreviewHelper               = /* CEB778E2-C202-4EC8-9085-0CD285CC5522 */ { 0xCE,0xB7,0x78,0xE2,0xC2,0x02,0x4E,0xC8,0x90,0x85,0x0C,0xD2,0x85,0xCC,0x55,0x22 };
BMD_CONST REFIID IID_IDeckLinkMetalScreenPreviewHelper            = /* C15739C7-A5EF-4F0E-A7CB-6806CB87E032 */ { 0xC1,0x57,0x39,0xC7,0xA5,0xEF,0x4F,0x0E,0xA7,0xCB,0x68,0x06,0xCB,0x87,0xE0,0x32 };
BMD_CONST REFIID IID_IDeckLinkNotificationCallback                = /* B002A1EC-070D-4288-8289-BD5D36E5FF0D */ { 0xB0,0x02,0xA1,0xEC,0x07,0x0D,0x42,0x88,0x82,0x89,0xBD,0x5D,0x36,0xE5,0xFF,0x0D };
BMD_CONST REFIID IID_IDeckLinkNotification                        = /* B85DF4C8-BDF5-47C1-8064-28162EBDD4EB */ { 0xB8,0x5D,0xF4,0xC8,0xBD,0xF5,0x47,0xC1,0x80,0x64,0x28,0x16,0x2E,0xBD,0xD4,0xEB };
BMD_CONST REFIID IID_IDeckLinkProfileAttributes                   = /* 17D4BF8E-4911-473A-80A0-731CF6FF345B */ { 0x17,0xD4,0xBF,0x8E,0x49,0x11,0x47,0x3A,0x80,0xA0,0x73,0x1C,0xF6,0xFF,0x34,0x5B };
BMD_CONST REFIID IID_IDeckLinkProfileIterator                     = /* 29E5A8C0-8BE4-46EB-93AC-31DAAB5B7BF2 */ { 0x29,0xE5,0xA8,0xC0,0x8B,0xE4,0x46,0xEB,0x93,0xAC,0x31,0xDA,0xAB,0x5B,0x7B,0xF2 };
BMD_CONST REFIID IID_IDeckLinkProfile                             = /* 16093466-674A-432B-9DA0-1AC2C5A8241C */ { 0x16,0x09,0x34,0x66,0x67,0x4A,0x43,0x2B,0x9D,0xA0,0x1A,0xC2,0xC5,0xA8,0x24,0x1C };
BMD_CONST REFIID IID_IDeckLinkProfileCallback                     = /* A4F9341E-97AA-4E04-8935-15F809898CEA */ { 0xA4,0xF9,0x34,0x1E,0x97,0xAA,0x4E,0x04,0x89,0x35,0x15,0xF8,0x09,0x89,0x8C,0xEA };
BMD_CONST REFIID IID_IDeckLinkProfileManager                      = /* 30D41429-3998-4B6D-84F8-78C94A797C6E */ { 0x30,0xD4,0x14,0x29,0x39,0x98,0x4B,0x6D,0x84,0xF8,0x78,0xC9,0x4A,0x79,0x7C,0x6E };
BMD_CONST REFIID IID_IDeckLinkStatus                              = /* 5F558200-4028-49BC-BEAC-DB3FA4A96E46 */ { 0x5F,0x55,0x82,0x00,0x40,0x28,0x49,0xBC,0xBE,0xAC,0xDB,0x3F,0xA4,0xA9,0x6E,0x46 };
BMD_CONST REFIID IID_IDeckLinkKeyer                               = /* 89AFCAF5-65F8-421E-98F7-96FE5F5BFBA3 */ { 0x89,0xAF,0xCA,0xF5,0x65,0xF8,0x42,0x1E,0x98,0xF7,0x96,0xFE,0x5F,0x5B,0xFB,0xA3 };
BMD_CONST REFIID IID_IDeckLinkVideoConversion                     = /* A48755D9-8BD5-4727-A1E9-069FDEDBA6E9 */ { 0xA4,0x87,0x55,0xD9,0x8B,0xD5,0x47,0x27,0xA1,0xE9,0x06,0x9F,0xDE,0xDB,0xA6,0xE9 };
BMD_CONST REFIID IID_IDeckLinkDeviceNotificationCallback          = /* 4997053B-0ADF-4CC8-AC70-7A50C4BE728F */ { 0x49,0x97,0x05,0x3B,0x0A,0xDF,0x4C,0xC8,0xAC,0x70,0x7A,0x50,0xC4,0xBE,0x72,0x8F };
BMD_CONST REFIID IID_IDeckLinkDiscovery                           = /* CDBF631C-BC76-45FA-B44D-C55059BC6101 */ { 0xCD,0xBF,0x63,0x1C,0xBC,0x76,0x45,0xFA,0xB4,0x4D,0xC5,0x50,0x59,0xBC,0x61,0x01 };

/* Enum BMDBufferAccessFlags - Flags to describe access requirements to a video frame buffer */

typedef uint32_t BMDBufferAccessFlags;
enum _BMDBufferAccessFlags {
    bmdBufferAccessReadAndWrite                                  = 1 << 0 | 1 << 1,
    bmdBufferAccessRead                                          = 1 << 0,
    bmdBufferAccessWrite                                         = 1 << 1
};

/* Enum BMDVideoOutputFlags - Flags to control the output of ancillary data along with video. */

typedef uint32_t BMDVideoOutputFlags;
enum _BMDVideoOutputFlags {
    bmdVideoOutputFlagDefault                                    = 0,
    bmdVideoOutputVANC                                           = 1 << 0,
    bmdVideoOutputVITC                                           = 1 << 1,
    bmdVideoOutputRP188                                          = 1 << 2,
    bmdVideoOutputDualStream3D                                   = 1 << 4,
    bmdVideoOutputSynchronizeToPlaybackGroup                     = 1 << 6,
    bmdVideoOutputDolbyVision                                    = 1 << 7
};

/* Enum BMDSupportedVideoModeFlags - Flags to describe supported video modes */

typedef uint32_t BMDSupportedVideoModeFlags;
enum _BMDSupportedVideoModeFlags {
    bmdSupportedVideoModeDefault                                 = 0,
    bmdSupportedVideoModeKeying                                  = 1 << 0,
    bmdSupportedVideoModeDualStream3D                            = 1 << 1,
    bmdSupportedVideoModeSDISingleLink                           = 1 << 2,
    bmdSupportedVideoModeSDIDualLink                             = 1 << 3,
    bmdSupportedVideoModeSDIQuadLink                             = 1 << 4,
    bmdSupportedVideoModeInAnyProfile                            = 1 << 5,
    bmdSupportedVideoModePsF                                     = 1 << 6,
    bmdSupportedVideoModeDolbyVision                             = 1 << 7
};

/* Enum BMDPacketType - Type of packet */

typedef uint32_t BMDPacketType;
enum _BMDPacketType {
    bmdPacketTypeStreamInterruptedMarker                         = /* 'sint' */ 0x73696E74,	// A packet of this type marks the time when a video stream was interrupted, for example by a disconnected cable
    bmdPacketTypeStreamData                                      = /* 'sdat' */ 0x73646174	// Regular stream data
};

/* Enum BMDFrameFlags - Frame flags */

typedef uint32_t BMDFrameFlags;
enum _BMDFrameFlags {
    bmdFrameFlagDefault                                          = 0,
    bmdFrameFlagFlipVertical                                     = 1 << 0,
    bmdFrameFlagMonitorOutOnly                                   = 1 << 3,
    bmdFrameContainsHDRMetadata                                  = 1 << 1,
    bmdFrameContainsDolbyVisionMetadata                          = 1 << 4,

    /* Flags that are applicable only to instances of IDeckLinkVideoInputFrame */

    bmdFrameCapturedAsPsF                                        = 1 << 30,
    bmdFrameHasNoInputSource                                     = 1 << 31
};

/* Enum BMDVideoInputFlags - Flags applicable to video input */

typedef uint32_t BMDVideoInputFlags;
enum _BMDVideoInputFlags {
    bmdVideoInputFlagDefault                                     = 0,
    bmdVideoInputEnableFormatDetection                           = 1 << 0,
    bmdVideoInputDualStream3D                                    = 1 << 1,
    bmdVideoInputSynchronizeToCaptureGroup                       = 1 << 2
};

/* Enum BMDVideoInputFormatChangedEvents - Bitmask passed to the VideoInputFormatChanged notification to identify the properties of the input signal that have changed */

typedef uint32_t BMDVideoInputFormatChangedEvents;
enum _BMDVideoInputFormatChangedEvents {
    bmdVideoInputDisplayModeChanged                              = 1 << 0,
    bmdVideoInputFieldDominanceChanged                           = 1 << 1,
    bmdVideoInputColorspaceChanged                               = 1 << 2
};

/* Enum BMDDetectedVideoInputFormatFlags - Flags passed to the VideoInputFormatChanged notification to describe the detected video input signal */

typedef uint32_t BMDDetectedVideoInputFormatFlags;
enum _BMDDetectedVideoInputFormatFlags {
    bmdDetectedVideoInputYCbCr422                                = 1 << 0,
    bmdDetectedVideoInputRGB444                                  = 1 << 1,
    bmdDetectedVideoInputDualStream3D                            = 1 << 2,
    bmdDetectedVideoInput12BitDepth                              = 1 << 3,
    bmdDetectedVideoInput10BitDepth                              = 1 << 4,
    bmdDetectedVideoInput8BitDepth                               = 1 << 5
};

/* Enum BMDDeckLinkCapturePassthroughMode - Enumerates whether the video output is electrically connected to the video input or if the clean switching mode is enabled */

typedef uint32_t BMDDeckLinkCapturePassthroughMode;
enum _BMDDeckLinkCapturePassthroughMode {
    bmdDeckLinkCapturePassthroughModeDisabled                    = /* 'pdis' */ 0x70646973,
    bmdDeckLinkCapturePassthroughModeDirect                      = /* 'pdir' */ 0x70646972,
    bmdDeckLinkCapturePassthroughModeCleanSwitch                 = /* 'pcln' */ 0x70636C6E
};

/* Enum BMDOutputFrameCompletionResult - Frame Completion Callback */

typedef uint32_t BMDOutputFrameCompletionResult;
enum _BMDOutputFrameCompletionResult {
    bmdOutputFrameCompleted,
    bmdOutputFrameDisplayedLate,
    bmdOutputFrameDropped,
    bmdOutputFrameFlushed
};

/* Enum BMDReferenceStatus - GenLock input status */

typedef uint32_t BMDReferenceStatus;
enum _BMDReferenceStatus {
    bmdReferenceUnlocked                                         = 0,
    bmdReferenceNotSupportedByHardware                           = 1 << 0,
    bmdReferenceLocked                                           = 1 << 1
};

/* Enum BMDAudioFormat - Audio Format */

typedef uint32_t BMDAudioFormat;
enum _BMDAudioFormat {
    bmdAudioFormatPCM                                            = /* 'lpcm' */ 0x6C70636D	// Linear signed PCM samples
};

/* Enum BMDAudioSampleRate - Audio sample rates supported for output/input */

typedef uint32_t BMDAudioSampleRate;
enum _BMDAudioSampleRate {
    bmdAudioSampleRate48kHz                                      = 48000
};

/* Enum BMDAudioSampleType - Audio sample sizes supported for output/input */

typedef uint32_t BMDAudioSampleType;
enum _BMDAudioSampleType {
    bmdAudioSampleType16bitInteger                               = 16,
    bmdAudioSampleType32bitInteger                               = 32
};

/* Enum BMDAudioOutputStreamType - Audio output stream type */

typedef uint32_t BMDAudioOutputStreamType;
enum _BMDAudioOutputStreamType {
    bmdAudioOutputStreamContinuous,
    bmdAudioOutputStreamContinuousDontResample,
    bmdAudioOutputStreamTimestamped
};

/* Enum BMDAncillaryPacketFormat - Ancillary packet format */

typedef uint32_t BMDAncillaryPacketFormat;
enum _BMDAncillaryPacketFormat {
    bmdAncillaryPacketFormatUInt8                                = /* 'ui08' */ 0x75693038,
    bmdAncillaryPacketFormatUInt16                               = /* 'ui16' */ 0x75693136,
    bmdAncillaryPacketFormatYCbCr10                              = /* 'v210' */ 0x76323130
};

/* Enum BMDTimecodeFormat - Timecode formats for frame metadata */

typedef uint32_t BMDTimecodeFormat;
enum _BMDTimecodeFormat {
    bmdTimecodeRP188VITC1                                        = /* 'rpv1' */ 0x72707631,	// RP188 timecode where DBB1 equals VITC1 (line 9)
    bmdTimecodeRP188VITC2                                        = /* 'rp12' */ 0x72703132,	// RP188 timecode where DBB1 equals VITC2 (line 9 for progressive or line 571 for interlaced/PsF)
    bmdTimecodeRP188LTC                                          = /* 'rplt' */ 0x72706C74,	// RP188 timecode where DBB1 equals LTC (line 10)
    bmdTimecodeRP188HighFrameRate                                = /* 'rphr' */ 0x72706872,	// RP188 timecode where DBB1 is an HFRTC (SMPTE ST 12-3), the only timecode allowing the frame value to go above 30
    bmdTimecodeRP188Any                                          = /* 'rp18' */ 0x72703138,	// Convenience for capture, returning the first valid timecode in {HFRTC (if supported), VITC1, VITC2, LTC }
    bmdTimecodeVITC                                              = /* 'vitc' */ 0x76697463,
    bmdTimecodeVITCField2                                        = /* 'vit2' */ 0x76697432,
    bmdTimecodeSerial                                            = /* 'seri' */ 0x73657269
};

/* Enum BMDAnalogVideoFlags - Analog video display flags */

typedef uint32_t BMDAnalogVideoFlags;
enum _BMDAnalogVideoFlags {
    bmdAnalogVideoFlagCompositeSetup75                           = 1 << 0,
    bmdAnalogVideoFlagComponentBetacamLevels                     = 1 << 1
};

/* Enum BMDAudioOutputAnalogAESSwitch - Audio output Analog/AESEBU switch */

typedef uint32_t BMDAudioOutputAnalogAESSwitch;
enum _BMDAudioOutputAnalogAESSwitch {
    bmdAudioOutputSwitchAESEBU                                   = /* 'aes ' */ 0x61657320,
    bmdAudioOutputSwitchAnalog                                   = /* 'anlg' */ 0x616E6C67
};

/* Enum BMDVideoOutputConversionMode - Video/audio conversion mode */

typedef uint32_t BMDVideoOutputConversionMode;
enum _BMDVideoOutputConversionMode {
    bmdNoVideoOutputConversion                                   = /* 'none' */ 0x6E6F6E65,
    bmdVideoOutputLetterboxDownconversion                        = /* 'ltbx' */ 0x6C746278,
    bmdVideoOutputAnamorphicDownconversion                       = /* 'amph' */ 0x616D7068,
    bmdVideoOutputHD720toHD1080Conversion                        = /* '720c' */ 0x37323063,
    bmdVideoOutputHardwareLetterboxDownconversion                = /* 'HWlb' */ 0x48576C62,
    bmdVideoOutputHardwareAnamorphicDownconversion               = /* 'HWam' */ 0x4857616D,
    bmdVideoOutputHardwareCenterCutDownconversion                = /* 'HWcc' */ 0x48576363,
    bmdVideoOutputHardware720p1080pCrossconversion               = /* 'xcap' */ 0x78636170,
    bmdVideoOutputHardwareAnamorphic720pUpconversion             = /* 'ua7p' */ 0x75613770,
    bmdVideoOutputHardwareAnamorphic1080iUpconversion            = /* 'ua1i' */ 0x75613169,
    bmdVideoOutputHardwareAnamorphic149To720pUpconversion        = /* 'u47p' */ 0x75343770,
    bmdVideoOutputHardwareAnamorphic149To1080iUpconversion       = /* 'u41i' */ 0x75343169,
    bmdVideoOutputHardwarePillarbox720pUpconversion              = /* 'up7p' */ 0x75703770,
    bmdVideoOutputHardwarePillarbox1080iUpconversion             = /* 'up1i' */ 0x75703169
};

/* Enum BMDVideoInputConversionMode - Video input conversion mode */

typedef uint32_t BMDVideoInputConversionMode;
enum _BMDVideoInputConversionMode {
    bmdNoVideoInputConversion                                    = /* 'none' */ 0x6E6F6E65,
    bmdVideoInputLetterboxDownconversionFromHD1080               = /* '10lb' */ 0x31306C62,
    bmdVideoInputAnamorphicDownconversionFromHD1080              = /* '10am' */ 0x3130616D,
    bmdVideoInputLetterboxDownconversionFromHD720                = /* '72lb' */ 0x37326C62,
    bmdVideoInputAnamorphicDownconversionFromHD720               = /* '72am' */ 0x3732616D,
    bmdVideoInputLetterboxUpconversion                           = /* 'lbup' */ 0x6C627570,
    bmdVideoInputAnamorphicUpconversion                          = /* 'amup' */ 0x616D7570
};

/* Enum BMDVideo3DPackingFormat - Video 3D packing format */

typedef uint32_t BMDVideo3DPackingFormat;
enum _BMDVideo3DPackingFormat {
    bmdVideo3DPackingSidebySideHalf                              = /* 'sbsh' */ 0x73627368,
    bmdVideo3DPackingLinebyLine                                  = /* 'lbyl' */ 0x6C62796C,
    bmdVideo3DPackingTopAndBottom                                = /* 'tabo' */ 0x7461626F,
    bmdVideo3DPackingFramePacking                                = /* 'frpk' */ 0x6672706B,
    bmdVideo3DPackingLeftOnly                                    = /* 'left' */ 0x6C656674,
    bmdVideo3DPackingRightOnly                                   = /* 'righ' */ 0x72696768
};

/* Enum BMDIdleVideoOutputOperation - Video output operation when not playing video */

typedef uint32_t BMDIdleVideoOutputOperation;
enum _BMDIdleVideoOutputOperation {
    bmdIdleVideoOutputBlack                                      = /* 'blac' */ 0x626C6163,
    bmdIdleVideoOutputLastFrame                                  = /* 'lafa' */ 0x6C616661
};

/* Enum BMDVideoEncoderFrameCodingMode - Video frame coding mode */

typedef uint32_t BMDVideoEncoderFrameCodingMode;
enum _BMDVideoEncoderFrameCodingMode {
    bmdVideoEncoderFrameCodingModeInter                          = /* 'inte' */ 0x696E7465,
    bmdVideoEncoderFrameCodingModeIntra                          = /* 'intr' */ 0x696E7472
};

/* Enum BMDDNxHRLevel - DNxHR Levels */

typedef uint32_t BMDDNxHRLevel;
enum _BMDDNxHRLevel {
    bmdDNxHRLevelSQ                                              = /* 'dnsq' */ 0x646E7371,
    bmdDNxHRLevelLB                                              = /* 'dnlb' */ 0x646E6C62,
    bmdDNxHRLevelHQ                                              = /* 'dnhq' */ 0x646E6871,
    bmdDNxHRLevelHQX                                             = /* 'dhqx' */ 0x64687178,
    bmdDNxHRLevel444                                             = /* 'd444' */ 0x64343434
};

/* Enum BMDLinkConfiguration - Video link configuration */

typedef uint32_t BMDLinkConfiguration;
enum _BMDLinkConfiguration {
    bmdLinkConfigurationSingleLink                               = /* 'lcsl' */ 0x6C63736C,
    bmdLinkConfigurationDualLink                                 = /* 'lcdl' */ 0x6C63646C,
    bmdLinkConfigurationQuadLink                                 = /* 'lcql' */ 0x6C63716C
};

/* Enum BMDDeviceInterface - Device interface type */

typedef uint32_t BMDDeviceInterface;
enum _BMDDeviceInterface {
    bmdDeviceInterfacePCI                                        = /* 'pci ' */ 0x70636920,
    bmdDeviceInterfaceUSB                                        = /* 'usb ' */ 0x75736220,
    bmdDeviceInterfaceThunderbolt                                = /* 'thun' */ 0x7468756E
};

/* Enum BMDColorspace - Colorspace */

typedef uint32_t BMDColorspace;
enum _BMDColorspace {
    bmdColorspaceRec601                                          = /* 'r601' */ 0x72363031,
    bmdColorspaceRec709                                          = /* 'r709' */ 0x72373039,
    bmdColorspaceRec2020                                         = /* '2020' */ 0x32303230,
    bmdColorspaceDolbyVisionNative                               = /* 'DoVi' */ 0x446F5669,	// For bmdDeckLinkConfigVideoOutputConversionColorspaceDestination with 12-bit RGB
    bmdColorspaceP3D65                                           = /* 'P3D6' */ 0x50334436,	// For bmdDeckLinkConfigVideoOutputConversionColorspaceSource only
    bmdColorspaceUnknown                                         = /* 'Ncol' */ 0x4E636F6C	// For disabling bmdDeckLinkConfigVideoOutputConversionColorspaceDestination
};

/* Enum BMDDynamicRange - SDR or HDR */

typedef uint32_t BMDDynamicRange;
enum _BMDDynamicRange {
    bmdDynamicRangeSDR                                           = 0,	// Standard Dynamic Range in accordance with SMPTE ST 2036-1
    bmdDynamicRangeHDRStaticPQ                                   = 1 << 29,	// High Dynamic Range PQ in accordance with SMPTE ST 2084
    bmdDynamicRangeHDRStaticHLG                                  = 1 << 30	// High Dynamic Range HLG in accordance with ITU-R BT.2100-0
};

/* Enum BMDMezzanineType -  */

typedef uint32_t BMDMezzanineType;
enum _BMDMezzanineType {
    bmdMezzanineTypeNone                                         = 0,	// No mezzanine board
    bmdMezzanineTypeHDMI14OpticalSDI                             = /* 'mza1' */ 0x6D7A6131,	// Mezzanine board with HDMI 1.4 and Optical SDI
    bmdMezzanineTypeQuadSDI                                      = /* 'mz4s' */ 0x6D7A3473,	// Mezzanine board with four SDI connectors
    bmdMezzanineTypeHDMI20OpticalSDI                             = /* 'mza2' */ 0x6D7A6132,	// Mezzanine board with HDMI 2.0 and Optical SDI
    bmdMezzanineTypeHDMI21RS422                                  = /* 'mzhr' */ 0x6D7A6872	// Mezzanine boards with HDMI 2.1 and RS422
};

/* Enum BMDDeckLinkHDMIInputEDIDID - DeckLink HDMI Input EDID ID */

typedef uint32_t BMDDeckLinkHDMIInputEDIDID;
enum _BMDDeckLinkHDMIInputEDIDID {

    /* Integers */

    bmdDeckLinkHDMIInputEDIDDynamicRange                         = /* 'HIDy' */ 0x48494479	// Parameter is of type BMDDynamicRange. Default is (bmdDynamicRangeSDR|bmdDynamicRangeHDRStaticPQ)
};

/* Enum BMDDeckLinkFrameMetadataID - DeckLink Frame Metadata ID */

typedef uint32_t BMDDeckLinkFrameMetadataID;
enum _BMDDeckLinkFrameMetadataID {

    /* Integers */

    bmdDeckLinkFrameMetadataColorspace                           = /* 'cspc' */ 0x63737063,	// Colorspace of video frame (see BMDColorspace)
    bmdDeckLinkFrameMetadataHDRElectroOpticalTransferFunc        = /* 'eotf' */ 0x656F7466,	// EOTF in range 0-7 as per CEA 861.3

    /* Dolby Vision only - Bytes */

    bmdDeckLinkFrameMetadataDolbyVision                          = /* 'dovi' */ 0x646F7669,	// Dolby Vision Metadata

    /* CEA/SMPTE only - HDR Metadata Floats */

    bmdDeckLinkFrameMetadataHDRDisplayPrimariesRedX              = /* 'hdrx' */ 0x68647278,	// Red display primaries in range 0.0 - 1.0
    bmdDeckLinkFrameMetadataHDRDisplayPrimariesRedY              = /* 'hdry' */ 0x68647279,	// Red display primaries in range 0.0 - 1.0
    bmdDeckLinkFrameMetadataHDRDisplayPrimariesGreenX            = /* 'hdgx' */ 0x68646778,	// Green display primaries in range 0.0 - 1.0
    bmdDeckLinkFrameMetadataHDRDisplayPrimariesGreenY            = /* 'hdgy' */ 0x68646779,	// Green display primaries in range 0.0 - 1.0
    bmdDeckLinkFrameMetadataHDRDisplayPrimariesBlueX             = /* 'hdbx' */ 0x68646278,	// Blue display primaries in range 0.0 - 1.0
    bmdDeckLinkFrameMetadataHDRDisplayPrimariesBlueY             = /* 'hdby' */ 0x68646279,	// Blue display primaries in range 0.0 - 1.0
    bmdDeckLinkFrameMetadataHDRWhitePointX                       = /* 'hdwx' */ 0x68647778,	// White point in range 0.0 - 1.0
    bmdDeckLinkFrameMetadataHDRWhitePointY                       = /* 'hdwy' */ 0x68647779,	// White point in range 0.0 - 1.0
    bmdDeckLinkFrameMetadataHDRMaxDisplayMasteringLuminance      = /* 'hdml' */ 0x68646D6C,	// Max display mastering luminance in range 1 cd/m2 - 65535 cd/m2
    bmdDeckLinkFrameMetadataHDRMinDisplayMasteringLuminance      = /* 'hmil' */ 0x686D696C,	// Min display mastering luminance in range 0.0001 cd/m2 - 6.5535 cd/m2
    bmdDeckLinkFrameMetadataHDRMaximumContentLightLevel          = /* 'mcll' */ 0x6D636C6C,	// Maximum Content Light Level in range 1 cd/m2 - 65535 cd/m2
    bmdDeckLinkFrameMetadataHDRMaximumFrameAverageLightLevel     = /* 'fall' */ 0x66616C6C	// Maximum Frame Average Light Level in range 1 cd/m2 - 65535 cd/m2
};

/* Enum BMDEthernetLinkState - The state of the Ethernet link */

typedef uint32_t BMDEthernetLinkState;
enum _BMDEthernetLinkState {
    bmdEthernetLinkStateDisconnected                             = /* 'elds' */ 0x656C6473,
    bmdEthernetLinkStateConnectedUnbound                         = /* 'elcu' */ 0x656C6375,
    bmdEthernetLinkStateConnectedBound                           = /* 'elcb' */ 0x656C6362
};

/* Enum BMDProfileID - Identifies a profile */

typedef uint32_t BMDProfileID;
enum _BMDProfileID {
    bmdProfileOneSubDeviceFullDuplex                             = /* '1dfd' */ 0x31646664,
    bmdProfileOneSubDeviceHalfDuplex                             = /* '1dhd' */ 0x31646864,
    bmdProfileTwoSubDevicesFullDuplex                            = /* '2dfd' */ 0x32646664,
    bmdProfileTwoSubDevicesHalfDuplex                            = /* '2dhd' */ 0x32646864,
    bmdProfileFourSubDevicesHalfDuplex                           = /* '4dhd' */ 0x34646864
};

/* Enum BMDHDMITimecodePacking - Packing form of timecode on HDMI */

typedef uint32_t BMDHDMITimecodePacking;
enum _BMDHDMITimecodePacking {
    bmdHDMITimecodePackingIEEEOUI000085                          = 0x00008500,
    bmdHDMITimecodePackingIEEEOUI080046                          = 0x08004601,
    bmdHDMITimecodePackingIEEEOUI5CF9F0                          = 0x5CF9F003
};

/* Enum BMDInternalKeyingAncillaryDataSource - Source for VANC and timecode data when performing internal keying */

typedef uint32_t BMDInternalKeyingAncillaryDataSource;
enum _BMDInternalKeyingAncillaryDataSource {
    bmdInternalKeyingUsesAncillaryDataFromInputSignal            = /* 'ikai' */ 0x696B6169,
    bmdInternalKeyingUsesAncillaryDataFromKeyFrame               = /* 'ikak' */ 0x696B616B
};

/* Enum BMDDeckLinkAttributeID - DeckLink Attribute ID */

typedef uint32_t BMDDeckLinkAttributeID;
enum _BMDDeckLinkAttributeID {

    /* Flags */

    BMDDeckLinkSupportsInternalKeying                            = /* 'keyi' */ 0x6B657969,
    BMDDeckLinkSupportsExternalKeying                            = /* 'keye' */ 0x6B657965,
    BMDDeckLinkSupportsInputFormatDetection                      = /* 'infd' */ 0x696E6664,
    BMDDeckLinkHasReferenceInput                                 = /* 'hrin' */ 0x6872696E,
    BMDDeckLinkHasSerialPort                                     = /* 'hspt' */ 0x68737074,
    BMDDeckLinkHasAnalogVideoOutputGain                          = /* 'avog' */ 0x61766F67,
    BMDDeckLinkCanOnlyAdjustOverallVideoOutputGain               = /* 'ovog' */ 0x6F766F67,
    BMDDeckLinkHasVideoInputAntiAliasingFilter                   = /* 'aafl' */ 0x6161666C,
    BMDDeckLinkHasBypass                                         = /* 'byps' */ 0x62797073,
    BMDDeckLinkSupportsClockTimingAdjustment                     = /* 'ctad' */ 0x63746164,
    BMDDeckLinkSupportsFullFrameReferenceInputTimingOffset       = /* 'frin' */ 0x6672696E,
    BMDDeckLinkSupportsSMPTELevelAOutput                         = /* 'lvla' */ 0x6C766C61,
    BMDDeckLinkSupportsAutoSwitchingPPsFOnInput                  = /* 'apsf' */ 0x61707366,
    BMDDeckLinkSupportsDualLinkSDI                               = /* 'sdls' */ 0x73646C73,
    BMDDeckLinkSupportsQuadLinkSDI                               = /* 'sqls' */ 0x73716C73,
    BMDDeckLinkSupportsIdleOutput                                = /* 'idou' */ 0x69646F75,
    BMDDeckLinkVANCRequires10BitYUVVideoFrames                   = /* 'vioY' */ 0x76696F59,	// Legacy product requires v210 active picture for IDeckLinkVideoFrameAncillaryPackets or 10-bit VANC
    BMDDeckLinkHasLTCTimecodeInput                               = /* 'hltc' */ 0x686C7463,
    BMDDeckLinkSupportsHDRMetadata                               = /* 'hdrm' */ 0x6864726D,
    BMDDeckLinkSupportsColorspaceMetadata                        = /* 'cmet' */ 0x636D6574,
    BMDDeckLinkSupportsHDMITimecode                              = /* 'htim' */ 0x6874696D,
    BMDDeckLinkSupportsHighFrameRateTimecode                     = /* 'HFRT' */ 0x48465254,
    BMDDeckLinkSupportsSynchronizeToCaptureGroup                 = /* 'stcg' */ 0x73746367,
    BMDDeckLinkSupportsSynchronizeToPlaybackGroup                = /* 'stpg' */ 0x73747067,
    BMDDeckLinkHasMonitorOut                                     = /* 'fmoo' */ 0x666D6F6F,

    /* Integers */

    BMDDeckLinkMaximumAudioChannels                              = /* 'mach' */ 0x6D616368,
    BMDDeckLinkMaximumHDMIAudioChannels                          = /* 'mhch' */ 0x6D686368,
    BMDDeckLinkMaximumAnalogAudioInputChannels                   = /* 'iach' */ 0x69616368,
    BMDDeckLinkMaximumAnalogAudioOutputChannels                  = /* 'aach' */ 0x61616368,
    BMDDeckLinkNumberOfSubDevices                                = /* 'nsbd' */ 0x6E736264,
    BMDDeckLinkSubDeviceIndex                                    = /* 'subi' */ 0x73756269,
    BMDDeckLinkPersistentID                                      = /* 'peid' */ 0x70656964,
    BMDDeckLinkDeviceGroupID                                     = /* 'dgid' */ 0x64676964,
    BMDDeckLinkTopologicalID                                     = /* 'toid' */ 0x746F6964,
    BMDDeckLinkVideoOutputConnections                            = /* 'vocn' */ 0x766F636E,	// Returns a BMDVideoConnection bit field
    BMDDeckLinkVideoInputConnections                             = /* 'vicn' */ 0x7669636E,	// Returns a BMDVideoConnection bit field
    BMDDeckLinkAudioOutputConnections                            = /* 'aocn' */ 0x616F636E,	// Returns a BMDAudioConnection bit field
    BMDDeckLinkAudioInputConnections                             = /* 'aicn' */ 0x6169636E,	// Returns a BMDAudioConnection bit field
    BMDDeckLinkVideoIOSupport                                    = /* 'vios' */ 0x76696F73,	// Returns a BMDVideoIOSupport bit field
    BMDDeckLinkDeckControlConnections                            = /* 'dccn' */ 0x6463636E,	// Returns a BMDDeckControlConnection bit field
    BMDDeckLinkDeviceInterface                                   = /* 'dbus' */ 0x64627573,	// Returns a BMDDeviceInterface
    BMDDeckLinkAudioInputRCAChannelCount                         = /* 'airc' */ 0x61697263,
    BMDDeckLinkAudioInputXLRChannelCount                         = /* 'aixc' */ 0x61697863,
    BMDDeckLinkAudioOutputRCAChannelCount                        = /* 'aorc' */ 0x616F7263,
    BMDDeckLinkAudioOutputXLRChannelCount                        = /* 'aoxc' */ 0x616F7863,
    BMDDeckLinkProfileID                                         = /* 'prid' */ 0x70726964,	// Returns a BMDProfileID
    BMDDeckLinkDuplex                                            = /* 'dupx' */ 0x64757078,
    BMDDeckLinkMinimumPrerollFrames                              = /* 'mprf' */ 0x6D707266,
    BMDDeckLinkSupportedDynamicRange                             = /* 'sudr' */ 0x73756472,
    BMDDeckLinkMezzanineType                                     = /* 'mezt' */ 0x6D657A74,

    /* Floats */

    BMDDeckLinkVideoInputGainMinimum                             = /* 'vigm' */ 0x7669676D,
    BMDDeckLinkVideoInputGainMaximum                             = /* 'vigx' */ 0x76696778,
    BMDDeckLinkVideoOutputGainMinimum                            = /* 'vogm' */ 0x766F676D,
    BMDDeckLinkVideoOutputGainMaximum                            = /* 'vogx' */ 0x766F6778,
    BMDDeckLinkMicrophoneInputGainMinimum                        = /* 'migm' */ 0x6D69676D,
    BMDDeckLinkMicrophoneInputGainMaximum                        = /* 'migx' */ 0x6D696778,

    /* Strings */

    BMDDeckLinkSerialPortDeviceName                              = /* 'slpn' */ 0x736C706E,
    BMDDeckLinkVendorName                                        = /* 'vndr' */ 0x766E6472,
    BMDDeckLinkDisplayName                                       = /* 'dspn' */ 0x6473706E,
    BMDDeckLinkModelName                                         = /* 'mdln' */ 0x6D646C6E,
    BMDDeckLinkDeviceHandle                                      = /* 'devh' */ 0x64657668,
    BMDDeckLinkEthernetMACAddress                                = /* 'eMAC' */ 0x654D4143
};

/* Enum BMDDeckLinkAPIInformationID - DeckLinkAPI information ID */

typedef uint32_t BMDDeckLinkAPIInformationID;
enum _BMDDeckLinkAPIInformationID {

    /* Integer or String */

    BMDDeckLinkAPIVersion                                        = /* 'vers' */ 0x76657273
};

/* Enum BMDDeckLinkStatusID - DeckLink Status ID */

typedef uint32_t BMDDeckLinkStatusID;
enum _BMDDeckLinkStatusID {

    /* Integers */

    bmdDeckLinkStatusDetectedVideoInputMode                      = /* 'dvim' */ 0x6476696D,
    bmdDeckLinkStatusDetectedVideoInputFormatFlags               = /* 'dvff' */ 0x64766666,
    bmdDeckLinkStatusDetectedVideoInputFieldDominance            = /* 'dvfd' */ 0x64766664,
    bmdDeckLinkStatusDetectedVideoInputColorspace                = /* 'dscl' */ 0x6473636C,
    bmdDeckLinkStatusDetectedVideoInputDynamicRange              = /* 'dsdr' */ 0x64736472,
    bmdDeckLinkStatusDetectedSDILinkConfiguration                = /* 'dslc' */ 0x64736C63,
    bmdDeckLinkStatusCurrentVideoInputMode                       = /* 'cvim' */ 0x6376696D,
    bmdDeckLinkStatusCurrentVideoInputPixelFormat                = /* 'cvip' */ 0x63766970,
    bmdDeckLinkStatusCurrentVideoInputFlags                      = /* 'cvif' */ 0x63766966,
    bmdDeckLinkStatusCurrentVideoOutputMode                      = /* 'cvom' */ 0x63766F6D,
    bmdDeckLinkStatusCurrentVideoOutputFlags                     = /* 'cvof' */ 0x63766F66,
    bmdDeckLinkStatusEthernetLink                                = /* 'sels' */ 0x73656C73,
    bmdDeckLinkStatusEthernetLinkMbps                            = /* 'sesp' */ 0x73657370,
    bmdDeckLinkStatusPCIExpressLinkWidth                         = /* 'pwid' */ 0x70776964,
    bmdDeckLinkStatusPCIExpressLinkSpeed                         = /* 'plnk' */ 0x706C6E6B,
    bmdDeckLinkStatusLastVideoOutputPixelFormat                  = /* 'opix' */ 0x6F706978,
    bmdDeckLinkStatusReferenceSignalMode                         = /* 'refm' */ 0x7265666D,
    bmdDeckLinkStatusReferenceSignalFlags                        = /* 'reff' */ 0x72656666,
    bmdDeckLinkStatusBusy                                        = /* 'busy' */ 0x62757379,
    bmdDeckLinkStatusInterchangeablePanelType                    = /* 'icpt' */ 0x69637074,
    bmdDeckLinkStatusDeviceTemperature                           = /* 'dtmp' */ 0x64746D70,
    bmdDeckLinkStatusHDMIOutputActualMode                        = /* 'hiam' */ 0x6869616D,
    bmdDeckLinkStatusHDMIOutputActualFormatFlags                 = /* 'hiaf' */ 0x68696166,
    bmdDeckLinkStatusHDMIOutputFRLRate                           = /* 'hiof' */ 0x68696F66,
    bmdDeckLinkStatusHDMIInputFRLRate                            = /* 'hiif' */ 0x68696966,
    bmdDeckLinkStatusHDMIOutputTMDSLineRate                      = /* 'hilr' */ 0x68696C72,

    /* Floats */

    bmdDeckLinkStatusSinkSupportsDolbyVision                     = /* 'dvvr' */ 0x64767672,

    /* Flags */

    bmdDeckLinkStatusVideoInputSignalLocked                      = /* 'visl' */ 0x7669736C,
    bmdDeckLinkStatusReferenceSignalLocked                       = /* 'refl' */ 0x7265666C,

    /* Strings */

    bmdDeckLinkStatusEthernetLocalIPAddress                      = /* 'seip' */ 0x73656970,
    bmdDeckLinkStatusEthernetSubnetMask                          = /* 'sesm' */ 0x7365736D,
    bmdDeckLinkStatusEthernetGatewayIPAddress                    = /* 'segw' */ 0x73656777,
    bmdDeckLinkStatusEthernetPrimaryDNS                          = /* 'sepd' */ 0x73657064,
    bmdDeckLinkStatusEthernetSecondaryDNS                        = /* 'sesd' */ 0x73657364,
    bmdDeckLinkStatusEthernetPTPGrandmasterIdentity              = /* 'spid' */ 0x73706964,
    bmdDeckLinkStatusEthernetVideoOutputAddress                  = /* 'soav' */ 0x736F6176,
    bmdDeckLinkStatusEthernetAudioOutputAddress                  = /* 'soaa' */ 0x736F6161,
    bmdDeckLinkStatusEthernetAncillaryOutputAddress              = /* 'soaA' */ 0x736F6141,
    bmdDeckLinkStatusEthernetAudioInputChannelOrder              = /* 'saco' */ 0x7361636F,

    /* Bytes */

    bmdDeckLinkStatusReceivedEDID                                = /* 'edid' */ 0x65646964
};

/* Enum BMDDeckLinkVideoStatusFlags -  */

typedef uint32_t BMDDeckLinkVideoStatusFlags;
enum _BMDDeckLinkVideoStatusFlags {
    bmdDeckLinkVideoStatusPsF                                    = 1 << 0,
    bmdDeckLinkVideoStatusDualStream3D                           = 1 << 1
};

/* Enum BMDDuplexMode - Duplex of the device */

typedef uint32_t BMDDuplexMode;
enum _BMDDuplexMode {
    bmdDuplexFull                                                = /* 'dxfu' */ 0x64786675,
    bmdDuplexHalf                                                = /* 'dxha' */ 0x64786861,
    bmdDuplexSimplex                                             = /* 'dxsp' */ 0x64787370,
    bmdDuplexInactive                                            = /* 'dxin' */ 0x6478696E
};

/* Enum BMDPanelType - The type of interchangeable panel */

typedef uint32_t BMDPanelType;
enum _BMDPanelType {
    bmdPanelNotDetected                                          = /* 'npnl' */ 0x6E706E6C,
    bmdPanelTeranexMiniSmartPanel                                = /* 'tmsm' */ 0x746D736D
};

/* Enum BMDFormatFlags - Flags to describe the video signal */

typedef uint32_t BMDFormatFlags;
enum _BMDFormatFlags {
    bmdFormatRGB444                                              = 1 << 0,
    bmdFormatYUV444                                              = 1 << 1,
    bmdFormatYUV422                                              = 1 << 2,
    bmdFormatYUV420                                              = 1 << 3,
    bmdFormat8BitDepth                                           = 1 << 4,
    bmdFormat10BitDepth                                          = 1 << 5,
    bmdFormat12BitDepth                                          = 1 << 6
};

/* Enum BMDDeviceBusyState - Current device busy state */

typedef uint32_t BMDDeviceBusyState;
enum _BMDDeviceBusyState {
    bmdDeviceCaptureBusy                                         = 1 << 0,
    bmdDevicePlaybackBusy                                        = 1 << 1,
    bmdDeviceSerialPortBusy                                      = 1 << 2
};

/* Enum BMDVideoIOSupport - Device video input/output support */

typedef uint32_t BMDVideoIOSupport;
enum _BMDVideoIOSupport {
    bmdDeviceSupportsCapture                                     = 1 << 0,
    bmdDeviceSupportsPlayback                                    = 1 << 1
};

/* Enum BMD3DPreviewFormat - Linked Frame preview format */

typedef uint32_t BMD3DPreviewFormat;
enum _BMD3DPreviewFormat {
    bmd3DPreviewFormatDefault                                    = /* 'defa' */ 0x64656661,
    bmd3DPreviewFormatLeftOnly                                   = /* 'left' */ 0x6C656674,
    bmd3DPreviewFormatRightOnly                                  = /* 'righ' */ 0x72696768,
    bmd3DPreviewFormatSideBySide                                 = /* 'side' */ 0x73696465,
    bmd3DPreviewFormatTopBottom                                  = /* 'topb' */ 0x746F7062
};

/* Enum BMDIPFlowDirection - BMDIPFlowDirection enumerates the direction of the IP flow. */

enum BMDIPFlowDirection {
    bmdDeckLinkIPFlowDirectionOutput                             = 0,
    bmdDeckLinkIPFlowDirectionInput                              = 1
};

/* Enum BMDIPFlowType - BMDIPFlowDirection enumerates the IP flow type. */

enum BMDIPFlowType {
    bmdDeckLinkIPFlowTypeVideo                                   = 0,
    bmdDeckLinkIPFlowTypeAudio                                   = 1,
    bmdDeckLinkIPFlowTypeAncillary                               = 2
};

/* Enum BMDDeckLinkIPFlowAttributeID - DeckLink IP Flow Attribute ID */

enum BMDDeckLinkIPFlowAttributeID {

    /* DeckLink IP Flow Attribute Integers */

    bmdDeckLinkIPFlowID                                          = /* '2fai' */ 0x32666169,
    bmdDeckLinkIPFlowDirection                                   = /* '2fad' */ 0x32666164,
    bmdDeckLinkIPFlowType                                        = /* '2fat' */ 0x32666174
};

/* Enum BMDDeckLinkIPFlowStatusID - DeckLink IP Flow Attribute ID */

enum BMDDeckLinkIPFlowStatusID {

    /* DeckLink IP Flow Status Strings */

    bmdDeckLinkIPFlowSDP                                         = /* '2fas' */ 0x32666173
};

/* Enum BMDDeckLinkIPFlowSettingID - DeckLink IP Flow Setting ID */

enum BMDDeckLinkIPFlowSettingID {

    /* DeckLink IP Flow Setting Strings */

    bmdDeckLinkIPFlowPeerSDP                                     = /* '2fps' */ 0x32667073	// The peer's SDP. Must not be over 1000 bytes large.
};

/* Enum BMDNotifications - Events that can be subscribed through IDeckLinkNotification */

typedef uint32_t BMDNotifications;
enum _BMDNotifications {
    bmdPreferencesChanged                                        = /* 'pref' */ 0x70726566,
    bmdStatusChanged                                             = /* 'stat' */ 0x73746174,
    bmdIPFlowStatusChanged                                       = /* 'bfsc' */ 0x62667363,
    bmdIPFlowSettingChanged                                      = /* 'bfcc' */ 0x62666363
};

#if defined(__cplusplus)

// Forward Declarations

class IDeckLinkVideoOutputCallback;
class IDeckLinkInputCallback;
class IDeckLinkEncoderInputCallback;
class IDeckLinkVideoBufferAllocator;
class IDeckLinkVideoBufferAllocatorProvider;
class IDeckLinkAudioOutputCallback;
class IDeckLinkIterator;
class IDeckLinkAPIInformation;
class IDeckLinkIPFlowAttributes;
class IDeckLinkIPFlowStatus;
class IDeckLinkIPFlowSetting;
class IDeckLinkIPFlow;
class IDeckLinkIPFlowIterator;
class IDeckLinkOutput;
class IDeckLinkMacOutput;
class IDeckLinkInput;
class IDeckLinkIPExtensions;
class IDeckLinkHDMIInputEDID;
class IDeckLinkEncoderInput;
class IDeckLinkVideoBuffer;
class IDeckLinkMacVideoBuffer;
class IDeckLinkVideoFrame;
class IDeckLinkMutableVideoFrame;
class IDeckLinkVideoFrame3DExtensions;
class IDeckLinkVideoFrameMetadataExtensions;
class IDeckLinkVideoFrameMutableMetadataExtensions;
class IDeckLinkVideoInputFrame;
class IDeckLinkAncillaryPacket;
class IDeckLinkAncillaryPacketIterator;
class IDeckLinkVideoFrameAncillaryPackets;
class IDeckLinkVideoFrameAncillary;
class IDeckLinkEncoderPacket;
class IDeckLinkEncoderVideoPacket;
class IDeckLinkEncoderAudioPacket;
class IDeckLinkH265NALPacket;
class IDeckLinkAudioInputPacket;
class IDeckLinkScreenPreviewCallback;
class IDeckLinkCocoaScreenPreviewCallback;
class IDeckLinkGLScreenPreviewHelper;
class IDeckLinkMetalScreenPreviewHelper;
class IDeckLinkNotificationCallback;
class IDeckLinkNotification;
class IDeckLinkProfileAttributes;
class IDeckLinkProfileIterator;
class IDeckLinkProfile;
class IDeckLinkProfileCallback;
class IDeckLinkProfileManager;
class IDeckLinkStatus;
class IDeckLinkKeyer;
class IDeckLinkVideoConversion;
class IDeckLinkDeviceNotificationCallback;
class IDeckLinkDiscovery;

/* Interface IDeckLinkVideoOutputCallback - Frame completion callback. */

class BMD_PUBLIC IDeckLinkVideoOutputCallback : public IUnknown
{
public:
    virtual HRESULT ScheduledFrameCompleted (/* in */ IDeckLinkVideoFrame* completedFrame, /* in */ BMDOutputFrameCompletionResult result) = 0;
    virtual HRESULT ScheduledPlaybackHasStopped (void) = 0;

protected:
    virtual ~IDeckLinkVideoOutputCallback () {} // call Release method to drop reference count
};

/* Interface IDeckLinkInputCallback - Frame arrival callback. */

class BMD_PUBLIC IDeckLinkInputCallback : public IUnknown
{
public:
    virtual HRESULT VideoInputFormatChanged (/* in */ BMDVideoInputFormatChangedEvents notificationEvents, /* in */ IDeckLinkDisplayMode* newDisplayMode, /* in */ BMDDetectedVideoInputFormatFlags detectedSignalFlags) = 0;
    virtual HRESULT VideoInputFrameArrived (/* in */ IDeckLinkVideoInputFrame* videoFrame, /* in */ IDeckLinkAudioInputPacket* audioPacket) = 0;

protected:
    virtual ~IDeckLinkInputCallback () {} // call Release method to drop reference count
};

/* Interface IDeckLinkEncoderInputCallback - Frame arrival callback. */

class BMD_PUBLIC IDeckLinkEncoderInputCallback : public IUnknown
{
public:
    virtual HRESULT VideoInputSignalChanged (/* in */ BMDVideoInputFormatChangedEvents notificationEvents, /* in */ IDeckLinkDisplayMode* newDisplayMode, /* in */ BMDDetectedVideoInputFormatFlags detectedSignalFlags) = 0;
    virtual HRESULT VideoPacketArrived (/* in */ IDeckLinkEncoderVideoPacket* videoPacket) = 0;
    virtual HRESULT AudioPacketArrived (/* in */ IDeckLinkEncoderAudioPacket* audioPacket) = 0;

protected:
    virtual ~IDeckLinkEncoderInputCallback () {} // call Release method to drop reference count
};

/* Interface IDeckLinkVideoBufferAllocator - Buffer allocator for video. */

class BMD_PUBLIC IDeckLinkVideoBufferAllocator : public IUnknown
{
public:
    virtual HRESULT AllocateVideoBuffer (/* out */ IDeckLinkVideoBuffer** allocatedBuffer) = 0;

protected:
    virtual ~IDeckLinkVideoBufferAllocator () {} // call Release method to drop reference count
};

/* Interface IDeckLinkVideoBufferAllocatorProvider - Allows EnableVideoInputWithAllocatorProvider to obtain allocators */

class BMD_PUBLIC IDeckLinkVideoBufferAllocatorProvider : public IUnknown
{
public:
    virtual HRESULT GetVideoBufferAllocator (/* in */ uint32_t bufferSize, /* in */ uint32_t width, /* in */ uint32_t height, /* in */ uint32_t rowBytes, /* in */ BMDPixelFormat pixelFormat, /* out */ IDeckLinkVideoBufferAllocator** allocator) = 0;

protected:
    virtual ~IDeckLinkVideoBufferAllocatorProvider () {} // call Release method to drop reference count
};

/* Interface IDeckLinkAudioOutputCallback - Optional callback to allow audio samples to be pulled as required. */

class BMD_PUBLIC IDeckLinkAudioOutputCallback : public IUnknown
{
public:
    virtual HRESULT RenderAudioSamples (/* in */ bool preroll) = 0;
};

/* Interface IDeckLinkIterator - Enumerates installed DeckLink hardware */

class BMD_PUBLIC IDeckLinkIterator : public IUnknown
{
public:
    virtual HRESULT Next (/* out */ IDeckLink** deckLinkInstance) = 0;
};

/* Interface IDeckLinkAPIInformation - DeckLinkAPI attribute interface */

class BMD_PUBLIC IDeckLinkAPIInformation : public IUnknown
{
public:
    virtual HRESULT GetFlag (/* in */ BMDDeckLinkAPIInformationID cfgID, /* out */ bool* value) = 0;
    virtual HRESULT GetInt (/* in */ BMDDeckLinkAPIInformationID cfgID, /* out */ int64_t* value) = 0;
    virtual HRESULT GetFloat (/* in */ BMDDeckLinkAPIInformationID cfgID, /* out */ double* value) = 0;
    virtual HRESULT GetString (/* in */ BMDDeckLinkAPIInformationID cfgID, /* out */ CFStringRef* value) = 0;

protected:
    virtual ~IDeckLinkAPIInformation () {} // call Release method to drop reference count
};

/* Interface IDeckLinkIPFlowAttributes -  */

class BMD_PUBLIC IDeckLinkIPFlowAttributes : public IUnknown
{
public:
    virtual HRESULT GetInt (/* in */ BMDDeckLinkIPFlowAttributeID attrID, /* out */ int64_t* value) = 0;
    virtual HRESULT GetFlag (/* in */ BMDDeckLinkIPFlowAttributeID attrID, /* out */ bool* value) = 0;
    virtual HRESULT GetFloat (/* in */ BMDDeckLinkIPFlowAttributeID attrID, /* out */ double* value) = 0;
    virtual HRESULT GetString (/* in */ BMDDeckLinkIPFlowAttributeID attrID, /* out */ CFStringRef* value) = 0;

protected:
    virtual ~IDeckLinkIPFlowAttributes () {} // call Release method to drop reference count
};

/* Interface IDeckLinkIPFlowStatus -  */

class BMD_PUBLIC IDeckLinkIPFlowStatus : public IUnknown
{
public:
    virtual HRESULT GetInt (/* in */ BMDDeckLinkIPFlowStatusID statusID, /* out */ int64_t* value) = 0;
    virtual HRESULT GetFlag (/* in */ BMDDeckLinkIPFlowStatusID statusID, /* out */ bool* value) = 0;
    virtual HRESULT GetFloat (/* in */ BMDDeckLinkIPFlowStatusID statusID, /* out */ double* value) = 0;
    virtual HRESULT GetString (/* in */ BMDDeckLinkIPFlowStatusID statusID, /* out */ CFStringRef* value) = 0;

protected:
    virtual ~IDeckLinkIPFlowStatus () {} // call Release method to drop reference count
};

/* Interface IDeckLinkIPFlowSetting -  */

class BMD_PUBLIC IDeckLinkIPFlowSetting : public IUnknown
{
public:
    virtual HRESULT GetInt (/* in */ BMDDeckLinkIPFlowSettingID settingID, /* out */ int64_t* value) = 0;
    virtual HRESULT GetFlag (/* in */ BMDDeckLinkIPFlowSettingID settingID, /* out */ bool* value) = 0;
    virtual HRESULT GetFloat (/* in */ BMDDeckLinkIPFlowSettingID settingID, /* out */ double* value) = 0;
    virtual HRESULT GetString (/* in */ BMDDeckLinkIPFlowSettingID settingID, /* out */ CFStringRef* value) = 0;
    virtual HRESULT SetInt (/* in */ BMDDeckLinkIPFlowSettingID settingID, /* in */ int64_t value) = 0;
    virtual HRESULT SetFlag (/* in */ BMDDeckLinkIPFlowSettingID settingID, /* in */ bool value) = 0;
    virtual HRESULT SetFloat (/* in */ BMDDeckLinkIPFlowSettingID settingID, /* in */ double value) = 0;
    virtual HRESULT SetString (/* in */ BMDDeckLinkIPFlowSettingID settingID, /* in */ CFStringRef value) = 0;

protected:
    virtual ~IDeckLinkIPFlowSetting () {} // call Release method to drop reference count
};

/* Interface IDeckLinkIPFlow -  */

class BMD_PUBLIC IDeckLinkIPFlow : public IUnknown
{
public:
    virtual HRESULT Enable (void) = 0;	// Enables an IP flow to start sending or receiving.
    virtual HRESULT Disable (void) = 0;	// Disables an IP flow to stop sending or receiving.

protected:
    virtual ~IDeckLinkIPFlow () {} // call Release method to drop reference count
};

/* Interface IDeckLinkIPFlowIterator - Enumerates DeckLink IP Flows */

class BMD_PUBLIC IDeckLinkIPFlowIterator : public IUnknown
{
public:
    virtual HRESULT Next (/* out */ IDeckLinkIPFlow** deckLinkIPFlowInstance) = 0;

protected:
    virtual ~IDeckLinkIPFlowIterator () {} // call Release method to drop reference count
};

/* Interface IDeckLinkOutput - Created by QueryInterface from IDeckLink. */

class BMD_PUBLIC IDeckLinkOutput : public IUnknown
{
public:
    virtual HRESULT DoesSupportVideoMode (/* in */ BMDVideoConnection connection /* If a value of bmdVideoConnectionUnspecified is specified, the caller does not care about the connection */, /* in */ BMDDisplayMode requestedMode, /* in */ BMDPixelFormat requestedPixelFormat, /* in */ BMDVideoOutputConversionMode conversionMode, /* in */ BMDSupportedVideoModeFlags flags, /* out */ BMDDisplayMode* actualMode, /* out */ bool* supported) = 0;
    virtual HRESULT GetDisplayMode (/* in */ BMDDisplayMode displayMode, /* out */ IDeckLinkDisplayMode** resultDisplayMode) = 0;
    virtual HRESULT GetDisplayModeIterator (/* out */ IDeckLinkDisplayModeIterator** iterator) = 0;
    virtual HRESULT SetScreenPreviewCallback (/* in */ IDeckLinkScreenPreviewCallback* previewCallback) = 0;

    /* Video Output */

    virtual HRESULT EnableVideoOutput (/* in */ BMDDisplayMode displayMode, /* in */ BMDVideoOutputFlags flags) = 0;
    virtual HRESULT DisableVideoOutput (void) = 0;
    virtual HRESULT CreateVideoFrame (/* in */ int32_t width, /* in */ int32_t height, /* in */ int32_t rowBytes, /* in */ BMDPixelFormat pixelFormat, /* in */ BMDFrameFlags flags, /* out */ IDeckLinkMutableVideoFrame** outFrame) = 0;
    virtual HRESULT CreateVideoFrameWithBuffer (/* in */ int32_t width, /* in */ int32_t height, /* in */ int32_t rowBytes, /* in */ BMDPixelFormat pixelFormat, /* in */ BMDFrameFlags flags, /* in */ IDeckLinkVideoBuffer* buffer, /* out */ IDeckLinkMutableVideoFrame** outFrame) = 0;
    virtual HRESULT RowBytesForPixelFormat (/* in */ BMDPixelFormat pixelFormat, /* in */ int32_t width, /* out */ int32_t* rowBytes) = 0;
    virtual HRESULT CreateAncillaryData (/* in */ BMDPixelFormat pixelFormat, /* out */ IDeckLinkVideoFrameAncillary** outBuffer) = 0;	// Use of IDeckLinkVideoFrameAncillaryPackets is preferred
    virtual HRESULT DisplayVideoFrameSync (/* in */ IDeckLinkVideoFrame* theFrame) = 0;
    virtual HRESULT ScheduleVideoFrame (/* in */ IDeckLinkVideoFrame* theFrame, /* in */ BMDTimeValue displayTime, /* in */ BMDTimeValue displayDuration, /* in */ BMDTimeScale timeScale) = 0;
    virtual HRESULT SetScheduledFrameCompletionCallback (/* in */ IDeckLinkVideoOutputCallback* theCallback) = 0;
    virtual HRESULT GetBufferedVideoFrameCount (/* out */ uint32_t* bufferedFrameCount) = 0;

    /* Audio Output */

    virtual HRESULT EnableAudioOutput (/* in */ BMDAudioSampleRate sampleRate, /* in */ BMDAudioSampleType sampleType, /* in */ uint32_t channelCount, /* in */ BMDAudioOutputStreamType streamType) = 0;
    virtual HRESULT DisableAudioOutput (void) = 0;
    virtual HRESULT WriteAudioSamplesSync (/* in */ void* buffer, /* in */ uint32_t sampleFrameCount, /* out */ uint32_t* sampleFramesWritten) = 0;
    virtual HRESULT BeginAudioPreroll (void) = 0;
    virtual HRESULT EndAudioPreroll (void) = 0;
    virtual HRESULT ScheduleAudioSamples (/* in */ void* buffer, /* in */ uint32_t sampleFrameCount, /* in */ BMDTimeValue streamTime, /* in */ BMDTimeScale timeScale, /* out */ uint32_t* sampleFramesWritten) = 0;
    virtual HRESULT GetBufferedAudioSampleFrameCount (/* out */ uint32_t* bufferedSampleFrameCount) = 0;
    virtual HRESULT FlushBufferedAudioSamples (void) = 0;
    virtual HRESULT SetAudioCallback (/* in */ IDeckLinkAudioOutputCallback* theCallback) = 0;

    /* Output Control */

    virtual HRESULT StartScheduledPlayback (/* in */ BMDTimeValue playbackStartTime, /* in */ BMDTimeScale timeScale, /* in */ double playbackSpeed) = 0;
    virtual HRESULT StopScheduledPlayback (/* in */ BMDTimeValue stopPlaybackAtTime, /* out */ BMDTimeValue* actualStopTime, /* in */ BMDTimeScale timeScale) = 0;
    virtual HRESULT IsScheduledPlaybackRunning (/* out */ bool* active) = 0;
    virtual HRESULT GetScheduledStreamTime (/* in */ BMDTimeScale desiredTimeScale, /* out */ BMDTimeValue* streamTime, /* out */ double* playbackSpeed) = 0;
    virtual HRESULT GetReferenceStatus (/* out */ BMDReferenceStatus* referenceStatus) = 0;

    /* Hardware Timing */

    virtual HRESULT GetHardwareReferenceClock (/* in */ BMDTimeScale desiredTimeScale, /* out */ BMDTimeValue* hardwareTime, /* out */ BMDTimeValue* timeInFrame, /* out */ BMDTimeValue* ticksPerFrame) = 0;
    virtual HRESULT GetFrameCompletionReferenceTimestamp (/* in */ IDeckLinkVideoFrame* theFrame, /* in */ BMDTimeScale desiredTimeScale, /* out */ BMDTimeValue* frameCompletionTimestamp) = 0;

protected:
    virtual ~IDeckLinkOutput () {} // call Release method to drop reference count
};

/* Interface IDeckLinkMacOutput - Created by QueryInterface from IDeckLinkOutput. */

class BMD_PUBLIC IDeckLinkMacOutput : public IUnknown
{
public:
    virtual HRESULT CreateVideoFrameFromCVPixelBufferRef (/* in */ void* cvPixelBuffer, /* out */ IDeckLinkMutableVideoFrame** outFrame) = 0;

protected:
    virtual ~IDeckLinkMacOutput () {} // call Release method to drop reference count
};

/* Interface IDeckLinkInput - Created by QueryInterface from IDeckLink. */

class BMD_PUBLIC IDeckLinkInput : public IUnknown
{
public:
    virtual HRESULT DoesSupportVideoMode (/* in */ BMDVideoConnection connection /* If a value of bmdVideoConnectionUnspecified is specified, the caller does not care about the connection */, /* in */ BMDDisplayMode requestedMode, /* in */ BMDPixelFormat requestedPixelFormat, /* in */ BMDVideoInputConversionMode conversionMode, /* in */ BMDSupportedVideoModeFlags flags, /* out */ BMDDisplayMode* actualMode, /* out */ bool* supported) = 0;
    virtual HRESULT GetDisplayMode (/* in */ BMDDisplayMode displayMode, /* out */ IDeckLinkDisplayMode** resultDisplayMode) = 0;
    virtual HRESULT GetDisplayModeIterator (/* out */ IDeckLinkDisplayModeIterator** iterator) = 0;
    virtual HRESULT SetScreenPreviewCallback (/* in */ IDeckLinkScreenPreviewCallback* previewCallback) = 0;

    /* Video Input */

    virtual HRESULT EnableVideoInput (/* in */ BMDDisplayMode displayMode, /* in */ BMDPixelFormat pixelFormat, /* in */ BMDVideoInputFlags flags) = 0;
    virtual HRESULT EnableVideoInputWithAllocatorProvider (/* in */ BMDDisplayMode displayMode, /* in */ BMDPixelFormat pixelFormat, /* in */ BMDVideoInputFlags flags, /* in */ IDeckLinkVideoBufferAllocatorProvider* allocatorProvider) = 0;
    virtual HRESULT DisableVideoInput (void) = 0;
    virtual HRESULT GetAvailableVideoFrameCount (/* out */ uint32_t* availableFrameCount) = 0;

    /* Audio Input */

    virtual HRESULT EnableAudioInput (/* in */ BMDAudioSampleRate sampleRate, /* in */ BMDAudioSampleType sampleType, /* in */ uint32_t channelCount) = 0;
    virtual HRESULT DisableAudioInput (void) = 0;
    virtual HRESULT GetAvailableAudioSampleFrameCount (/* out */ uint32_t* availableSampleFrameCount) = 0;

    /* Input Control */

    virtual HRESULT StartStreams (void) = 0;
    virtual HRESULT StopStreams (void) = 0;
    virtual HRESULT PauseStreams (void) = 0;
    virtual HRESULT FlushStreams (void) = 0;
    virtual HRESULT SetCallback (/* in */ IDeckLinkInputCallback* theCallback) = 0;

    /* Hardware Timing */

    virtual HRESULT GetHardwareReferenceClock (/* in */ BMDTimeScale desiredTimeScale, /* out */ BMDTimeValue* hardwareTime, /* out */ BMDTimeValue* timeInFrame, /* out */ BMDTimeValue* ticksPerFrame) = 0;

protected:
    virtual ~IDeckLinkInput () {} // call Release method to drop reference count
};

/* Interface IDeckLinkIPExtensions -  */

class BMD_PUBLIC IDeckLinkIPExtensions : public IUnknown
{
public:
    virtual HRESULT GetDeckLinkIPFlowIterator (/* out */ IDeckLinkIPFlowIterator** iterator) = 0;
    virtual HRESULT GetIPFlowByID (/* in */ BMDIPFlowID id, /* out */ IDeckLinkIPFlow** flow) = 0;

protected:
    virtual ~IDeckLinkIPExtensions () {} // call Release method to drop reference count
};

/* Interface IDeckLinkHDMIInputEDID - Created by QueryInterface from IDeckLink. Releasing all references will restore EDID to default */

class BMD_PUBLIC IDeckLinkHDMIInputEDID : public IUnknown
{
public:
    virtual HRESULT SetInt (/* in */ BMDDeckLinkHDMIInputEDIDID cfgID, /* in */ int64_t value) = 0;
    virtual HRESULT GetInt (/* in */ BMDDeckLinkHDMIInputEDIDID cfgID, /* out */ int64_t* value) = 0;
    virtual HRESULT WriteToEDID (void) = 0;

protected:
    virtual ~IDeckLinkHDMIInputEDID () {} // call Release method to drop reference count
};

/* Interface IDeckLinkEncoderInput - Created by QueryInterface from IDeckLink. */

class BMD_PUBLIC IDeckLinkEncoderInput : public IUnknown
{
public:
    virtual HRESULT DoesSupportVideoMode (/* in */ BMDVideoConnection connection /* If a value of bmdVideoConnectionUnspecified is specified, the caller does not care about the connection */, /* in */ BMDDisplayMode requestedMode, /* in */ BMDPixelFormat requestedCodec, /* in */ uint32_t requestedCodecProfile, /* in */ BMDSupportedVideoModeFlags flags, /* out */ bool* supported) = 0;
    virtual HRESULT GetDisplayMode (/* in */ BMDDisplayMode displayMode, /* out */ IDeckLinkDisplayMode** resultDisplayMode) = 0;
    virtual HRESULT GetDisplayModeIterator (/* out */ IDeckLinkDisplayModeIterator** iterator) = 0;

    /* Video Input */

    virtual HRESULT EnableVideoInput (/* in */ BMDDisplayMode displayMode, /* in */ BMDPixelFormat pixelFormat, /* in */ BMDVideoInputFlags flags) = 0;
    virtual HRESULT DisableVideoInput (void) = 0;
    virtual HRESULT GetAvailablePacketsCount (/* out */ uint32_t* availablePacketsCount) = 0;

    /* Audio Input */

    virtual HRESULT EnableAudioInput (/* in */ BMDAudioFormat audioFormat, /* in */ BMDAudioSampleRate sampleRate, /* in */ BMDAudioSampleType sampleType, /* in */ uint32_t channelCount) = 0;
    virtual HRESULT DisableAudioInput (void) = 0;
    virtual HRESULT GetAvailableAudioSampleFrameCount (/* out */ uint32_t* availableSampleFrameCount) = 0;

    /* Input Control */

    virtual HRESULT StartStreams (void) = 0;
    virtual HRESULT StopStreams (void) = 0;
    virtual HRESULT PauseStreams (void) = 0;
    virtual HRESULT FlushStreams (void) = 0;
    virtual HRESULT SetCallback (/* in */ IDeckLinkEncoderInputCallback* theCallback) = 0;

    /* Hardware Timing */

    virtual HRESULT GetHardwareReferenceClock (/* in */ BMDTimeScale desiredTimeScale, /* out */ BMDTimeValue* hardwareTime, /* out */ BMDTimeValue* timeInFrame, /* out */ BMDTimeValue* ticksPerFrame) = 0;

protected:
    virtual ~IDeckLinkEncoderInput () {} // call Release method to drop reference count
};

/* Interface IDeckLinkVideoBuffer - Interface to encapsulate a video frame buffer; can be caller-implemented. */

class BMD_PUBLIC IDeckLinkVideoBuffer : public IUnknown
{
public:
    virtual HRESULT GetBytes (/* out */ void** buffer) = 0;
    virtual HRESULT StartAccess (/* in */ BMDBufferAccessFlags flags) = 0;
    virtual HRESULT EndAccess (/* in */ BMDBufferAccessFlags flags) = 0;

protected:
    virtual ~IDeckLinkVideoBuffer () {} // call Release method to drop reference count
};

/* Interface IDeckLinkMacVideoBuffer - Video buffer helper functions for macOS; can be caller-implemented. */

class BMD_PUBLIC IDeckLinkMacVideoBuffer : public IUnknown
{
public:
    virtual HRESULT CreateCVPixelBufferRef (/* out */ void** cvPixelBuffer) = 0;

protected:
    virtual ~IDeckLinkMacVideoBuffer () {} // call Release method to drop reference count
};

/* Interface IDeckLinkVideoFrame - Interface to encapsulate a video frame; can be caller-implemented. */

class BMD_PUBLIC IDeckLinkVideoFrame : public IUnknown
{
public:
    virtual long GetWidth (void) = 0;
    virtual long GetHeight (void) = 0;
    virtual long GetRowBytes (void) = 0;
    virtual BMDPixelFormat GetPixelFormat (void) = 0;
    virtual BMDFrameFlags GetFlags (void) = 0;
    virtual HRESULT GetTimecode (/* in */ BMDTimecodeFormat format, /* out */ IDeckLinkTimecode** timecode) = 0;
    virtual HRESULT GetAncillaryData (/* out */ IDeckLinkVideoFrameAncillary** ancillary) = 0;	// Use of IDeckLinkVideoFrameAncillaryPackets is preferred

protected:
    virtual ~IDeckLinkVideoFrame () {} // call Release method to drop reference count
};

/* Interface IDeckLinkMutableVideoFrame - Created by IDeckLinkOutput::CreateVideoFrame. */

class BMD_PUBLIC IDeckLinkMutableVideoFrame : public IDeckLinkVideoFrame
{
public:
    virtual HRESULT SetFlags (/* in */ BMDFrameFlags newFlags) = 0;
    virtual HRESULT SetTimecode (/* in */ BMDTimecodeFormat format, /* in */ IDeckLinkTimecode* timecode) = 0;
    virtual HRESULT SetTimecodeFromComponents (/* in */ BMDTimecodeFormat format, /* in */ uint8_t hours, /* in */ uint8_t minutes, /* in */ uint8_t seconds, /* in */ uint8_t frames, /* in */ BMDTimecodeFlags flags) = 0;
    virtual HRESULT SetAncillaryData (/* in */ IDeckLinkVideoFrameAncillary* ancillary) = 0;
    virtual HRESULT SetTimecodeUserBits (/* in */ BMDTimecodeFormat format, /* in */ BMDTimecodeUserBits userBits) = 0;
    virtual HRESULT SetInterfaceProvider (/* in */ REFIID iid, /* in */ IUnknown* iface) = 0;

protected:
    virtual ~IDeckLinkMutableVideoFrame () {} // call Release method to drop reference count
};

/* Interface IDeckLinkVideoFrame3DExtensions - Optional interface to support 3D frames. */

class BMD_PUBLIC IDeckLinkVideoFrame3DExtensions : public IUnknown
{
public:
    virtual BMDVideo3DPackingFormat Get3DPackingFormat (void) = 0;
    virtual HRESULT GetFrameForRightEye (/* out */ IDeckLinkVideoFrame** rightEyeFrame) = 0;

protected:
    virtual ~IDeckLinkVideoFrame3DExtensions () {} // call Release method to drop reference count
};

/* Interface IDeckLinkVideoFrameMetadataExtensions - Get frame metadata */

class BMD_PUBLIC IDeckLinkVideoFrameMetadataExtensions : public IUnknown
{
public:
    virtual HRESULT GetInt (/* in */ BMDDeckLinkFrameMetadataID metadataID, /* out */ int64_t* value) = 0;
    virtual HRESULT GetFloat (/* in */ BMDDeckLinkFrameMetadataID metadataID, /* out */ double* value) = 0;
    virtual HRESULT GetFlag (/* in */ BMDDeckLinkFrameMetadataID metadataID, /* out */ bool* value) = 0;
    virtual HRESULT GetString (/* in */ BMDDeckLinkFrameMetadataID metadataID, /* out */ CFStringRef* value) = 0;
    virtual HRESULT GetBytes (/* in */ BMDDeckLinkFrameMetadataID metadataID, /* out */ void* buffer /* optional */, /* in, out */ uint32_t* bufferSize) = 0;

protected:
    virtual ~IDeckLinkVideoFrameMetadataExtensions () {} // call Release method to drop reference count
};

/* Interface IDeckLinkVideoFrameMutableMetadataExtensions - Set frame metadata */

class BMD_PUBLIC IDeckLinkVideoFrameMutableMetadataExtensions : public IDeckLinkVideoFrameMetadataExtensions
{
public:
    virtual HRESULT SetInt (/* in */ BMDDeckLinkFrameMetadataID metadataID, /* in */ int64_t value) = 0;
    virtual HRESULT SetFloat (/* in */ BMDDeckLinkFrameMetadataID metadataID, /* in */ double value) = 0;
    virtual HRESULT SetFlag (/* in */ BMDDeckLinkFrameMetadataID metadataID, /* in */ bool value) = 0;
    virtual HRESULT SetString (/* in */ BMDDeckLinkFrameMetadataID metadataID, /* in */ CFStringRef value) = 0;
    virtual HRESULT SetBytes (/* in */ BMDDeckLinkFrameMetadataID metadataID, /* in */ void* buffer, /* in */ uint32_t bufferSize) = 0;

protected:
    virtual ~IDeckLinkVideoFrameMutableMetadataExtensions () {} // call Release method to drop reference count
};

/* Interface IDeckLinkVideoInputFrame - Provided by the IDeckLinkVideoInput frame arrival callback. */

class BMD_PUBLIC IDeckLinkVideoInputFrame : public IDeckLinkVideoFrame
{
public:
    virtual HRESULT GetStreamTime (/* out */ BMDTimeValue* frameTime, /* out */ BMDTimeValue* frameDuration, /* in */ BMDTimeScale timeScale) = 0;
    virtual HRESULT GetHardwareReferenceTimestamp (/* in */ BMDTimeScale timeScale, /* out */ BMDTimeValue* frameTime, /* out */ BMDTimeValue* frameDuration) = 0;

protected:
    virtual ~IDeckLinkVideoInputFrame () {} // call Release method to drop reference count
};

/* Interface IDeckLinkAncillaryPacket - On output, user needs to implement this interface */

class BMD_PUBLIC IDeckLinkAncillaryPacket : public IUnknown
{
public:
    virtual HRESULT GetBytes (/* in */ BMDAncillaryPacketFormat format /* For output, only one format need be offered */, /* out */ const void** data /* Optional */, /* out */ uint32_t* size /* Optional */) = 0;
    virtual uint8_t GetDID (void) = 0;
    virtual uint8_t GetSDID (void) = 0;
    virtual uint32_t GetLineNumber (void) = 0;	// On output, zero is auto
    virtual uint8_t GetDataStreamIndex (void) = 0;	// Usually zero. Can only be 1 if non-SD and the first data stream is completely full

protected:
    virtual ~IDeckLinkAncillaryPacket () {} // call Release method to drop reference count
};

/* Interface IDeckLinkAncillaryPacketIterator - Enumerates ancillary packets */

class BMD_PUBLIC IDeckLinkAncillaryPacketIterator : public IUnknown
{
public:
    virtual HRESULT Next (/* out */ IDeckLinkAncillaryPacket** packet) = 0;

protected:
    virtual ~IDeckLinkAncillaryPacketIterator () {} // call Release method to drop reference count
};

/* Interface IDeckLinkVideoFrameAncillaryPackets - Obtained through QueryInterface on an IDeckLinkVideoFrame object. */

class BMD_PUBLIC IDeckLinkVideoFrameAncillaryPackets : public IUnknown
{
public:
    virtual HRESULT GetPacketIterator (/* out */ IDeckLinkAncillaryPacketIterator** iterator) = 0;
    virtual HRESULT GetFirstPacketByID (/* in */ uint8_t DID, /* in */ uint8_t SDID, /* out */ IDeckLinkAncillaryPacket** packet) = 0;
    virtual HRESULT AttachPacket (/* in */ IDeckLinkAncillaryPacket* packet) = 0;	// Implement IDeckLinkAncillaryPacket to output your own
    virtual HRESULT DetachPacket (/* in */ IDeckLinkAncillaryPacket* packet) = 0;
    virtual HRESULT DetachAllPackets (void) = 0;

protected:
    virtual ~IDeckLinkVideoFrameAncillaryPackets () {} // call Release method to drop reference count
};

/* Interface IDeckLinkVideoFrameAncillary - Use of IDeckLinkVideoFrameAncillaryPackets is preferred. Obtained through QueryInterface on an IDeckLinkVideoFrame object. */

class BMD_PUBLIC IDeckLinkVideoFrameAncillary : public IUnknown
{
public:
    virtual HRESULT GetBufferForVerticalBlankingLine (/* in */ uint32_t lineNumber, /* out */ void** buffer) = 0;	// Pixels/rowbytes is same as display mode, except for above HD where it's 1920 pixels for UHD modes and 2048 pixels for DCI modes
    virtual BMDPixelFormat GetPixelFormat (void) = 0;
    virtual BMDDisplayMode GetDisplayMode (void) = 0;

protected:
    virtual ~IDeckLinkVideoFrameAncillary () {} // call Release method to drop reference count
};

/* Interface IDeckLinkEncoderPacket - Interface to encapsulate an encoded packet. */

class BMD_PUBLIC IDeckLinkEncoderPacket : public IUnknown
{
public:
    virtual HRESULT GetBytes (/* out */ void** buffer) = 0;
    virtual long GetSize (void) = 0;
    virtual HRESULT GetStreamTime (/* out */ BMDTimeValue* frameTime, /* in */ BMDTimeScale timeScale) = 0;
    virtual BMDPacketType GetPacketType (void) = 0;

protected:
    virtual ~IDeckLinkEncoderPacket () {} // call Release method to drop reference count
};

/* Interface IDeckLinkEncoderVideoPacket - Provided by the IDeckLinkEncoderInput video packet arrival callback. */

class BMD_PUBLIC IDeckLinkEncoderVideoPacket : public IDeckLinkEncoderPacket
{
public:
    virtual BMDPixelFormat GetPixelFormat (void) = 0;
    virtual HRESULT GetHardwareReferenceTimestamp (/* in */ BMDTimeScale timeScale, /* out */ BMDTimeValue* frameTime, /* out */ BMDTimeValue* frameDuration) = 0;
    virtual HRESULT GetTimecode (/* in */ BMDTimecodeFormat format, /* out */ IDeckLinkTimecode** timecode) = 0;

protected:
    virtual ~IDeckLinkEncoderVideoPacket () {} // call Release method to drop reference count
};

/* Interface IDeckLinkEncoderAudioPacket - Provided by the IDeckLinkEncoderInput audio packet arrival callback. */

class BMD_PUBLIC IDeckLinkEncoderAudioPacket : public IDeckLinkEncoderPacket
{
public:
    virtual BMDAudioFormat GetAudioFormat (void) = 0;

protected:
    virtual ~IDeckLinkEncoderAudioPacket () {} // call Release method to drop reference count
};

/* Interface IDeckLinkH265NALPacket - Obtained through QueryInterface on an IDeckLinkEncoderVideoPacket object */

class BMD_PUBLIC IDeckLinkH265NALPacket : public IDeckLinkEncoderVideoPacket
{
public:
    virtual HRESULT GetUnitType (/* out */ uint8_t* unitType) = 0;
    virtual HRESULT GetBytesNoPrefix (/* out */ void** buffer) = 0;
    virtual long GetSizeNoPrefix (void) = 0;

protected:
    virtual ~IDeckLinkH265NALPacket () {} // call Release method to drop reference count
};

/* Interface IDeckLinkAudioInputPacket - Provided by the IDeckLinkInput callback. */

class BMD_PUBLIC IDeckLinkAudioInputPacket : public IUnknown
{
public:
    virtual long GetSampleFrameCount (void) = 0;
    virtual HRESULT GetBytes (/* out */ void** buffer) = 0;
    virtual HRESULT GetPacketTime (/* out */ BMDTimeValue* packetTime, /* in */ BMDTimeScale timeScale) = 0;

protected:
    virtual ~IDeckLinkAudioInputPacket () {} // call Release method to drop reference count
};

/* Interface IDeckLinkScreenPreviewCallback - Screen preview callback */

class BMD_PUBLIC IDeckLinkScreenPreviewCallback : public IUnknown
{
public:
    virtual HRESULT DrawFrame (/* in */ IDeckLinkVideoFrame* theFrame) = 0;

protected:
    virtual ~IDeckLinkScreenPreviewCallback () {} // call Release method to drop reference count
};

/* Interface IDeckLinkCocoaScreenPreviewCallback - Screen preview callback for Cocoa-based applications. Created with CreateCocoaScreenPreview */

class BMD_PUBLIC IDeckLinkCocoaScreenPreviewCallback : public IDeckLinkScreenPreviewCallback
{
public:

protected:
    virtual ~IDeckLinkCocoaScreenPreviewCallback () {} // call Release method to drop reference count
};

/* Interface IDeckLinkGLScreenPreviewHelper - Created with CoCreateInstance on platforms with native COM support or from CreateOpenGLScreenPreviewHelper/CreateOpenGL3ScreenPreviewHelper on other platforms. */

class BMD_PUBLIC IDeckLinkGLScreenPreviewHelper : public IUnknown
{
public:

    /* Methods must be called with OpenGL context set */

    virtual HRESULT InitializeGL (void) = 0;
    virtual HRESULT PaintGL (void) = 0;
    virtual HRESULT SetFrame (/* in */ IDeckLinkVideoFrame* theFrame) = 0;
    virtual HRESULT Set3DPreviewFormat (/* in */ BMD3DPreviewFormat previewFormat) = 0;

protected:
    virtual ~IDeckLinkGLScreenPreviewHelper () {} // call Release method to drop reference count
};

/* Interface IDeckLinkMetalScreenPreviewHelper - Created with CreateMetalScreenPreviewHelper(). */

class BMD_PUBLIC IDeckLinkMetalScreenPreviewHelper : public IUnknown
{
public:
    virtual HRESULT Initialize (/* in */ void* device) = 0;
    virtual HRESULT Draw (/* in */ void* cmdBuffer, /* in */ void* renderPassDescriptor, /* in */ void* viewport) = 0;
    virtual HRESULT SetFrame (/* in */ IDeckLinkVideoFrame* theFrame) = 0;
    virtual HRESULT Set3DPreviewFormat (/* in */ BMD3DPreviewFormat previewFormat) = 0;

protected:
    virtual ~IDeckLinkMetalScreenPreviewHelper () {} // call Release method to drop reference count
};

/* Interface IDeckLinkNotificationCallback - DeckLink Notification Callback Interface */

class BMD_PUBLIC IDeckLinkNotificationCallback : public IUnknown
{
public:
    virtual HRESULT Notify (/* in */ BMDNotifications topic, /* in */ uint64_t param1, /* in */ uint64_t param2) = 0;
};

/* Interface IDeckLinkNotification - DeckLink Notification interface */

class BMD_PUBLIC IDeckLinkNotification : public IUnknown
{
public:
    virtual HRESULT Subscribe (/* in */ BMDNotifications topic, /* in */ IDeckLinkNotificationCallback* theCallback) = 0;
    virtual HRESULT Unsubscribe (/* in */ BMDNotifications topic, /* in */ IDeckLinkNotificationCallback* theCallback) = 0;

protected:
    virtual ~IDeckLinkNotification () {} // call Release method to drop reference count
};

/* Interface IDeckLinkProfileAttributes - Created by QueryInterface from an IDeckLinkProfile, or from IDeckLink. When queried from IDeckLink, interrogates the active profile */

class BMD_PUBLIC IDeckLinkProfileAttributes : public IUnknown
{
public:
    virtual HRESULT GetFlag (/* in */ BMDDeckLinkAttributeID cfgID, /* out */ bool* value) = 0;
    virtual HRESULT GetInt (/* in */ BMDDeckLinkAttributeID cfgID, /* out */ int64_t* value) = 0;
    virtual HRESULT GetFloat (/* in */ BMDDeckLinkAttributeID cfgID, /* out */ double* value) = 0;
    virtual HRESULT GetString (/* in */ BMDDeckLinkAttributeID cfgID, /* out */ CFStringRef* value) = 0;

protected:
    virtual ~IDeckLinkProfileAttributes () {} // call Release method to drop reference count
};

/* Interface IDeckLinkProfileIterator - Enumerates IDeckLinkProfile interfaces */

class BMD_PUBLIC IDeckLinkProfileIterator : public IUnknown
{
public:
    virtual HRESULT Next (/* out */ IDeckLinkProfile** profile) = 0;

protected:
    virtual ~IDeckLinkProfileIterator () {} // call Release method to drop reference count
};

/* Interface IDeckLinkProfile - Represents the active profile when queried from IDeckLink */

class BMD_PUBLIC IDeckLinkProfile : public IUnknown
{
public:
    virtual HRESULT GetDevice (/* out */ IDeckLink** device) = 0;	// Device affected when this profile becomes active
    virtual HRESULT IsActive (/* out */ bool* isActive) = 0;
    virtual HRESULT SetActive (void) = 0;	// Activating a profile will also change the profile on all devices enumerated by GetPeers. Activation is not complete until IDeckLinkProfileCallback::ProfileActivated is called
    virtual HRESULT GetPeers (/* out */ IDeckLinkProfileIterator** profileIterator) = 0;	// Profiles of other devices activated with this profile

protected:
    virtual ~IDeckLinkProfile () {} // call Release method to drop reference count
};

/* Interface IDeckLinkProfileCallback - Receive notifications about profiles related to this device */

class BMD_PUBLIC IDeckLinkProfileCallback : public IUnknown
{
public:
    virtual HRESULT ProfileChanging (/* in */ IDeckLinkProfile* profileToBeActivated, /* in */ bool streamsWillBeForcedToStop) = 0;	// Called before this device changes profile. User has an opportunity for teardown if streamsWillBeForcedToStop
    virtual HRESULT ProfileActivated (/* in */ IDeckLinkProfile* activatedProfile) = 0;	// Called after this device has been activated with a new profile

protected:
    virtual ~IDeckLinkProfileCallback () {} // call Release method to drop reference count
};

/* Interface IDeckLinkProfileManager - Created by QueryInterface from IDeckLink when a device has multiple optional profiles */

class BMD_PUBLIC IDeckLinkProfileManager : public IUnknown
{
public:
    virtual HRESULT GetProfiles (/* out */ IDeckLinkProfileIterator** profileIterator) = 0;	// All available profiles for this device
    virtual HRESULT GetProfile (/* in */ BMDProfileID profileID, /* out */ IDeckLinkProfile** profile) = 0;
    virtual HRESULT SetCallback (/* in */ IDeckLinkProfileCallback* callback) = 0;

protected:
    virtual ~IDeckLinkProfileManager () {} // call Release method to drop reference count
};

/* Interface IDeckLinkStatus - DeckLink Status interface */

class BMD_PUBLIC IDeckLinkStatus : public IUnknown
{
public:
    virtual HRESULT GetFlag (/* in */ BMDDeckLinkStatusID statusID, /* out */ bool* value) = 0;
    virtual HRESULT GetInt (/* in */ BMDDeckLinkStatusID statusID, /* out */ int64_t* value) = 0;
    virtual HRESULT GetFloat (/* in */ BMDDeckLinkStatusID statusID, /* out */ double* value) = 0;
    virtual HRESULT GetString (/* in */ BMDDeckLinkStatusID statusID, /* out */ CFStringRef* value) = 0;
    virtual HRESULT GetBytes (/* in */ BMDDeckLinkStatusID statusID, /* out */ void* buffer, /* in, out */ uint32_t* bufferSize) = 0;

protected:
    virtual ~IDeckLinkStatus () {} // call Release method to drop reference count
};

/* Interface IDeckLinkKeyer - DeckLink Keyer interface */

class BMD_PUBLIC IDeckLinkKeyer : public IUnknown
{
public:
    virtual HRESULT Enable (/* in */ bool isExternal) = 0;
    virtual HRESULT SetLevel (/* in */ uint8_t level) = 0;
    virtual HRESULT RampUp (/* in */ uint32_t numberOfFrames) = 0;
    virtual HRESULT RampDown (/* in */ uint32_t numberOfFrames) = 0;
    virtual HRESULT Disable (void) = 0;

protected:
    virtual ~IDeckLinkKeyer () {} // call Release method to drop reference count
};

/* Interface IDeckLinkVideoConversion - Created with CoCreateInstance. */

class BMD_PUBLIC IDeckLinkVideoConversion : public IUnknown
{
public:
    virtual HRESULT ConvertFrame (/* in */ IDeckLinkVideoFrame* srcFrame, /* in */ IDeckLinkVideoFrame* dstFrame) = 0;
    virtual HRESULT ConvertNewFrame (/* in */ IDeckLinkVideoFrame* srcFrame, /* in */ BMDPixelFormat dstPixelFormat, /* in */ BMDColorspace dstColorspace, /* in */ IDeckLinkVideoBuffer* dstBuffer, /* out */ IDeckLinkVideoFrame** dstFrame) = 0;

protected:
    virtual ~IDeckLinkVideoConversion () {} // call Release method to drop reference count
};

/* Interface IDeckLinkDeviceNotificationCallback - DeckLink device arrival/removal notification callbacks */

class BMD_PUBLIC IDeckLinkDeviceNotificationCallback : public IUnknown
{
public:
    virtual HRESULT DeckLinkDeviceArrived (/* in */ IDeckLink* deckLinkDevice) = 0;
    virtual HRESULT DeckLinkDeviceRemoved (/* in */ IDeckLink* deckLinkDevice) = 0;

protected:
    virtual ~IDeckLinkDeviceNotificationCallback () {} // call Release method to drop reference count
};

/* Interface IDeckLinkDiscovery - DeckLink device discovery */

class BMD_PUBLIC IDeckLinkDiscovery : public IUnknown
{
public:
    virtual HRESULT InstallDeviceNotifications (/* in */ IDeckLinkDeviceNotificationCallback* deviceNotificationCallback) = 0;
    virtual HRESULT UninstallDeviceNotifications (void) = 0;

protected:
    virtual ~IDeckLinkDiscovery () {} // call Release method to drop reference count
};

/* Functions */

extern "C" {

    BMD_PUBLIC IDeckLinkIterator* CreateDeckLinkIteratorInstance(void);
    BMD_PUBLIC IDeckLinkDiscovery* CreateDeckLinkDiscoveryInstance(void);
    BMD_PUBLIC IDeckLinkAPIInformation* CreateDeckLinkAPIInformationInstance(void);
    BMD_PUBLIC IDeckLinkGLScreenPreviewHelper* CreateOpenGLScreenPreviewHelper(void);
    BMD_PUBLIC IDeckLinkGLScreenPreviewHelper* CreateOpenGL3ScreenPreviewHelper(void);	// Requires OpenGL 3.2 support and provides improved performance and color handling
    BMD_PUBLIC IDeckLinkCocoaScreenPreviewCallback* CreateCocoaScreenPreview(/* in */ void* /* (NSView*)*/ parentView);
    BMD_PUBLIC IDeckLinkMetalScreenPreviewHelper* CreateMetalScreenPreviewHelper(void);
    BMD_PUBLIC IDeckLinkVideoConversion* CreateVideoConversionInstance(void);
    BMD_PUBLIC IDeckLinkVideoFrameAncillaryPackets* CreateVideoFrameAncillaryPacketsInstance(void);	// For use when creating a custom IDeckLinkVideoFrame without wrapping IDeckLinkOutput::CreateVideoFrame

}



#endif /* defined(__cplusplus) */
#endif /* defined(BMD_DECKLINKAPI_H) */
