/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2024 Realtek Corporation. All rights reserved
 */

#include "../r8169_ethdev.h"
#include "../r8169_hw.h"
#include "../r8169_phy.h"
#include "rtl8125cp_mcu.h"

/* For RTL8125CP, CFG_METHOD_58 */

/* ------------------------------------MAC 8125CP------------------------------------- */

/* No mac mcu patch code */

/* ------------------------------------PHY 8125CP------------------------------------- */

static const u16 phy_mcu_ram_code_8125cp_1_1[] = {
	0xa436, 0x8023, 0xa438, 0x2300, 0xa436, 0xB82E, 0xa438, 0x0001,
	0xb820, 0x0090, 0xa436, 0xA016, 0xa438, 0x0000, 0xa436, 0xA012,
	0xa438, 0x07f8, 0xa436, 0xA014, 0xa438, 0xcc01, 0xa438, 0x2166,
	0xa438, 0x0000, 0xa438, 0x0000, 0xa438, 0x0000, 0xa438, 0x0000,
	0xa438, 0x0000, 0xa438, 0x0000, 0xa436, 0xA152, 0xa438, 0x021c,
	0xa436, 0xA154, 0xa438, 0x2170, 0xa436, 0xA156, 0xa438, 0x3fff,
	0xa436, 0xA158, 0xa438, 0x3fff, 0xa436, 0xA15A, 0xa438, 0x3fff,
	0xa436, 0xA15C, 0xa438, 0x3fff, 0xa436, 0xA15E, 0xa438, 0x3fff,
	0xa436, 0xA160, 0xa438, 0x3fff, 0xa436, 0xA150, 0xa438, 0x0003,
	0xa436, 0xA016, 0xa438, 0x0020, 0xa436, 0xA012, 0xa438, 0x0000,
	0xa436, 0xA014, 0xa438, 0x1800, 0xa438, 0x8010, 0xa438, 0x1800,
	0xa438, 0x801b, 0xa438, 0x1800, 0xa438, 0x802b, 0xa438, 0x1800,
	0xa438, 0x8031, 0xa438, 0x1800, 0xa438, 0x8031, 0xa438, 0x1800,
	0xa438, 0x8031, 0xa438, 0x1800, 0xa438, 0x8031, 0xa438, 0x1800,
	0xa438, 0x8031, 0xa438, 0x800a, 0xa438, 0x8530, 0xa438, 0x0c03,
	0xa438, 0x1502, 0xa438, 0x8d10, 0xa438, 0x9503, 0xa438, 0xd700,
	0xa438, 0x6050, 0xa438, 0xaa20, 0xa438, 0x1800, 0xa438, 0x0d53,
	0xa438, 0xd707, 0xa438, 0x40f6, 0xa438, 0x8901, 0xa438, 0xd704,
	0xa438, 0x6091, 0xa438, 0x8306, 0xa438, 0x8b02, 0xa438, 0x8290,
	0xa438, 0x1000, 0xa438, 0x0e4d, 0xa438, 0x1000, 0xa438, 0x1277,
	0xa438, 0xd704, 0xa438, 0x7e77, 0xa438, 0x1800, 0xa438, 0x0dc5,
	0xa438, 0xd700, 0xa438, 0x4063, 0xa438, 0x1800, 0xa438, 0x0d15,
	0xa438, 0x1800, 0xa438, 0x0d18, 0xa436, 0xA10E, 0xa438, 0xffff,
	0xa436, 0xA10C, 0xa438, 0xffff, 0xa436, 0xA10A, 0xa438, 0xffff,
	0xa436, 0xA108, 0xa438, 0xffff, 0xa436, 0xA106, 0xa438, 0xffff,
	0xa436, 0xA104, 0xa438, 0x0d13, 0xa436, 0xA102, 0xa438, 0x0dbf,
	0xa436, 0xA100, 0xa438, 0x0d52, 0xa436, 0xA110, 0xa438, 0x0007,
	0xa436, 0xb87c, 0xa438, 0x85bd, 0xa436, 0xb87e, 0xa438, 0xaf85,
	0xa438, 0xd5af, 0xa438, 0x85fb, 0xa438, 0xaf85, 0xa438, 0xfbaf,
	0xa438, 0x85fb, 0xa438, 0xaf85, 0xa438, 0xfbaf, 0xa438, 0x85fb,
	0xa438, 0xaf85, 0xa438, 0xfbaf, 0xa438, 0x85fb, 0xa438, 0xac28,
	0xa438, 0x0bd4, 0xa438, 0x0294, 0xa438, 0xbf85, 0xa438, 0xf802,
	0xa438, 0x61c2, 0xa438, 0xae09, 0xa438, 0xd414, 0xa438, 0x50bf,
	0xa438, 0x85f8, 0xa438, 0x0261, 0xa438, 0xc2bf, 0xa438, 0x60de,
	0xa438, 0x0261, 0xa438, 0xe1bf, 0xa438, 0x80cf, 0xa438, 0xaf24,
	0xa438, 0xe8f0, 0xa438, 0xac52, 0xa436, 0xb85e, 0xa438, 0x24e5,
	0xa436, 0xb860, 0xa438, 0xffff, 0xa436, 0xb862, 0xa438, 0xffff,
	0xa436, 0xb864, 0xa438, 0xffff, 0xa436, 0xb886, 0xa438, 0xffff,
	0xa436, 0xb888, 0xa438, 0xffff, 0xa436, 0xb88a, 0xa438, 0xffff,
	0xa436, 0xb88c, 0xa438, 0xffff, 0xa436, 0xb838, 0xa438, 0x0001,
	0xb820, 0x0010, 0xB82E, 0x0000, 0xa436, 0x8023, 0xa438, 0x0000,
	0xB820, 0x0000, 0xFFFF, 0xFFFF
};

static void
rtl_real_set_phy_mcu_8125cp_1_1(struct rtl_hw *hw)
{
	rtl_set_phy_mcu_ram_code(hw, phy_mcu_ram_code_8125cp_1_1,
				 ARRAY_SIZE(phy_mcu_ram_code_8125cp_1_1));
}

void
rtl_set_phy_mcu_8125cp_1(struct rtl_hw *hw)
{
	rtl_set_phy_mcu_patch_request(hw);

	rtl_real_set_phy_mcu_8125cp_1_1(hw);

	rtl_clear_phy_mcu_patch_request(hw);
}
